<?php
/*!
* Authifly
* https://hybridauth.github.io | https://github.com/mailoptin/authifly
*  (c) 2017 Hybridauth authors | https://hybridauth.github.io/license.html
*/

namespace Authifly\HttpClient;

/**
 * AuthiFly Http clients interface
 */
interface HttpClientInterface
{
    /**
    * Send request to the remote server
    *
    * Returns the result (Raw response from the server) on success, FALSE on failure
    *
    * @param string $uri
    * @param string $method
    * @param array  $parameters
    * @param array  $headers
    *
    * @return mixed
    */
    public function request($uri, $method = 'GET', $parameters = [], $headers = []);

    /**
    * Returns raw response from the server on success, FALSE on failure
    *
    * @return mixed
    */
    public function getResponseBody();

    /**
    * Retriever the headers returned in the response
    *
    * @return array
    */
    public function getResponseHeader();

    /**
    * Returns latest request HTTP status code
    *
    * @return integer
    */
    public function getResponseHttpCode();

    /**
    * Returns latest error encountered by the client
    * This can be either a code or error message
    *
    * @return mixed
    */
    public function getResponseClientError();
}
