<?php
namespace ElementorEventzilla;

/**
 * Class Plugin
 *
 * Main Plugin class
 * @since 1.0.0
 */
class Plugin {

  /**
   * Instance
   *
   * @since 1.0.0
   * @access private
   * @static
   *
   * @var Plugin The single instance of the class.
   */
  private static $_instance = null;

  /**
   * Instance
   *
   * Ensures only one instance of the class is loaded or can be loaded.
   *
   * @since 1.2.0
   * @access public
   *
   * @return Plugin An instance of the class.
   */
  public static function instance() {
    if ( is_null( self::$_instance ) ) {
      self::$_instance = new self();
    }

    return self::$_instance;
  }

  /**
   * widget_scripts
   *
   * Load required plugin core files.
   *
   * @since 1.2.0
   * @access public
   */
  public function widget_scripts() {
    // the calendar css
    wp_enqueue_style('lbg-evento-dcalendar-css', plugins_url('evento/css/dcalendar.picker.css', __FILE__));
    wp_enqueue_style('lbg-evento-site-css', plugins_url('evento/css/lbg_evento.css', __FILE__));

    // the calendar js
    wp_enqueue_script('jquery');
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-ui-slider');
		wp_enqueue_script('jquery-effects-core');

    wp_register_script('lbg-evento-26e31fe740', plugins_url('evento/js/26e31fe740.js', __FILE__));
		wp_enqueue_script('lbg-evento-26e31fe740');

		wp_register_script('lbg-evento', plugins_url('evento/js/lbg_evento.js', __FILE__));
		wp_enqueue_script('lbg-evento');

		wp_register_script('lbg-dcalendar', plugins_url('evento/js/dcalendar.picker.js', __FILE__));
		wp_enqueue_script('lbg-dcalendar');
  }

  /**
   * Include Widgets files
   *
   * Load widgets files
   *
   * @since 1.2.0
   * @access private
   */
  private function include_widgets_files() {
    require_once( __DIR__ . '/widgets/eventzilla.php' );
  }

  /**
   * Register Widgets
   *
   * Register new Elementor widgets.
   *
   * @since 1.2.0
   * @access public
   */
  public function register_widgets() {
    // Its is now safe to include Widgets files
    $this->include_widgets_files();

    // Register Widgets
    \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Eventzilla() );
  }


  /**
   * lbg register_categories
   */
   public function register_categories( $elements_manager ) {
       $elements_manager->add_category(
         'lambert-widgets',
         [
           'title' => esc_html__( 'Lambert Widgets', 'elementor-eventzilla' ),
           'icon' => 'fa fa-plug',
         ]
       );
     }


  /**
   *  Plugin class constructor
   *
   * Register plugin action hooks and filters
   *
   * @since 1.2.0
   * @access public
   */
  public function __construct() {
    // Register widget scripts
    add_action( 'elementor/frontend/after_register_scripts', [ $this, 'widget_scripts' ] );

    // Register widgets
    add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );


    //lbg - new categ
    add_action( 'elementor/elements/categories_registered', [ $this, 'register_categories' ] );

  }
}

// Instantiate Plugin Class
Plugin::instance();
