<?php
namespace ElementorEventzilla\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * @since 1.1.0
 */
class Eventzilla extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.1.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'Eventozilla_Event_Calendar';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.1.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'Eventozilla - Event Calendar', 'elementor-eventzilla' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.1.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'eicon-calendar';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.1.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'lambert-widgets' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.1.0
   *
   * @access protected
   */
  protected function register_controls() {
    //general controls (ex content)
    $this->start_controls_section(
      'general_content',
      [
        'label' => esc_html__( 'General', 'elementor-eventzilla' ),
      ]
    );

    $this->add_control(
      'width',
      [
        'label' => esc_html__( 'Calendar Width', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 100,
        'max' => 10000,
        'step' => 1,
        'default' => 720,
      ]
    );
    $this->add_control(
			'centerPlugin',
			[
				'label' => esc_html__( 'Center Calendar', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
				'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
    $this->add_control(
			'showMonthFirstForDate',
			[
				'label' => esc_html__( 'Show The Month First In The Date', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
				'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
    $this->add_control(
			'showEndDate',
			[
				'label' => esc_html__( 'Show End Date', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
				'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
    $this->add_control(
      'searchInputText',
      [
        'label' => esc_html__( 'Translate "Search" Text', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'search...',
      ]
    );
    $this->add_control(
      'eventsListVerticalPadding',
      [
        'label' => esc_html__( 'Event Vertical Padding', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 20,
      ]
    );
    $this->add_control(
      'eventsListHorizontalPadding',
      [
        'label' => esc_html__( 'Event Horizontal Padding', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 10,
      ]
    );
    $this->add_control(
      'eventTitleLeftMargin',
      [
        'label' => esc_html__( 'Event Title Left Margin', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 15,
      ]
    );
    $this->add_control(
      'eventTitleFontSize',
      [
        'label' => esc_html__( 'Event Title Font Size', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 27,
      ]
    );
    $this->add_control(
      'eventFirstDateFontSize',
      [
        'label' => esc_html__( 'Event First Date Font Size', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 92,
      ]
    );
    $this->add_control(
      'eventSecondDateFontSize',
      [
        'label' => esc_html__( 'Event Second Date Font Size', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 20,
      ]
    );
    $this->add_control(
      'eventSecondDateMonthFontSize',
      [
        'label' => esc_html__( 'Event Second Date Month Font Size', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 13,
      ]
    );
    $this->add_control(
      'eventInitialDetailsFontSize',
      [
        'label' => esc_html__( 'Event Initial Details Font Size', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 14,
      ]
    );
    $this->add_control(
      'eventBottomBorderColor',
      [
        'label' => esc_html__( 'Event Bottom Border Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'default' => '#CCCCCC',
      ]
    );
    $this->add_control(
      'eventBackgroundColor_odd',
      [
        'label' => esc_html__( 'Event Bg. Color - For Odd Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#ffffff',
      ]
    );
    $this->add_control(
      'eventBackgroundColor_even',
      [
        'label' => esc_html__( 'Event Bg. Color - For Even Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#ebebeb',
      ]
    );
    $this->add_control(
      'eventBgDayColor_odd',
      [
        'label' => esc_html__( 'Event Bg. for Day Color (Vertical Text) - For Odd Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#da0000',
      ]
    );
    $this->add_control(
      'eventBgDayColor_even',
      [
        'label' => esc_html__( 'Event Bg. for Day Color (Vertical Text) - For Even Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#000000',
      ]
    );
    $this->add_control(
      'eventDateColor_odd',
      [
        'label' => esc_html__( 'Event Date Color - For Odd Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#444444',
      ]
    );
    $this->add_control(
      'eventDateColor_even',
      [
        'label' => esc_html__( 'Event Date Color - For Even Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#444444',
      ]
    );
    $this->add_control(
      'eventTitleColor_odd',
      [
        'label' => esc_html__( 'Event Title Color - For Odd Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#444444',
      ]
    );
    $this->add_control(
      'eventTitleColor_even',
      [
        'label' => esc_html__( 'Event Title Color - For Even Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#444444',
      ]
    );
    $this->add_control(
      'eventInitialDetailsColor_odd',
      [
        'label' => esc_html__( 'Event Initial Details Color - For Odd Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#444444',
      ]
    );
    $this->add_control(
      'eventInitialDetailsColor_even',
      [
        'label' => esc_html__( 'Event Initial Details Color - For Even Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#444444',
      ]
    );
    $this->add_control(
      'dressCode',
      [
        'label' => esc_html__( 'Translate "Dress Code" Text', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'Dress code',
      ]
    );
    $this->add_control(
      'dressCodeFontSize',
      [
        'label' => esc_html__( 'Dress Code Font Size', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'default' => 13,
      ]
    );
    $this->add_control(
      'dressCodeColor_odd',
      [
        'label' => esc_html__( 'Dress Code Color - For Odd Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#808080',
      ]
    );
    $this->add_control(
      'dressCodeColor_even',
      [
        'label' => esc_html__( 'Dress Code Color - For Even Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#808080',
      ]
    );
    $this->add_control(
      'socialIconsColor_odd',
      [
        'label' => esc_html__( 'Social Icons Color - For Odd Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#FFFFFF',
      ]
    );
    $this->add_control(
      'socialIconsColor_even',
      [
        'label' => esc_html__( 'Social Icons Color - For Even Item in the Events List', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#FFFFFF',
      ]
    );
    $this->add_control(
      'shortmonth_Jan',
      [
        'label' => esc_html__( 'January Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Jan',
      ]
    );
    $this->add_control(
      'shortmonth_Feb',
      [
        'label' => esc_html__( 'February Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Feb',
      ]
    );
    $this->add_control(
      'shortmonth_Mar',
      [
        'label' => esc_html__( 'March Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Mar',
      ]
    );
    $this->add_control(
      'shortmonth_Apr',
      [
        'label' => esc_html__( 'April Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Apr',
      ]
    );
    $this->add_control(
      'shortmonth_May',
      [
        'label' => esc_html__( 'May Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'May',
      ]
    );
    $this->add_control(
      'shortmonth_Jun',
      [
        'label' => esc_html__( 'June Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Jun',
      ]
    );
    $this->add_control(
      'shortmonth_Jul',
      [
        'label' => esc_html__( 'July Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Jul',
      ]
    );
    $this->add_control(
      'shortmonth_Aug',
      [
        'label' => esc_html__( 'August Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Aug',
      ]
    );
    $this->add_control(
      'shortmonth_Sep',
      [
        'label' => esc_html__( 'September Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Sep',
      ]
    );
    $this->add_control(
      'shortmonth_Oct',
      [
        'label' => esc_html__( 'October Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Oct',
      ]
    );
    $this->add_control(
      'shortmonth_Nov',
      [
        'label' => esc_html__( 'November Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Nov',
      ]
    );
    $this->add_control(
      'shortmonth_Dec',
      [
        'label' => esc_html__( 'December Abbreviation', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Dec',
      ]
    );
    $this->add_control(
      'longdays_Sunday',
      [
        'label' => esc_html__( 'Sunday', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Sunday',
      ]
    );
    $this->add_control(
      'longdays_Monday',
      [
        'label' => esc_html__( 'Monday', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Monday',
      ]
    );
    $this->add_control(
      'longdays_Tuesday',
      [
        'label' => esc_html__( 'Tuesday', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Tuesday',
      ]
    );
    $this->add_control(
      'longdays_Wednesday',
      [
        'label' => esc_html__( 'Wednesday', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Wednesday',
      ]
    );
    $this->add_control(
      'longdays_Thursday',
      [
        'label' => esc_html__( 'Thursday', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Thursday',
      ]
    );
    $this->add_control(
      'longdays_Friday',
      [
        'label' => esc_html__( 'Friday', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Friday',
      ]
    );
    $this->add_control(
      'longdays_Saturday',
      [
        'label' => esc_html__( 'Saturday', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'default' => 'Saturday',
      ]
    );
    $this->add_control(
      'Sunday_color',
      [
        'label' => esc_html__( 'If the "Event Bg for Day Color (Vertical Text)" is defined the following 7 parameters will be ignored. Sunday (Vertical Text) Background Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#fff000',
      ]
    );
    $this->add_control(
      'Monday_color',
      [
        'label' => esc_html__( 'Monday (Vertical Text) Background Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#00ffe0',
      ]
    );
    $this->add_control(
      'Tuesday_color',
      [
        'label' => esc_html__( 'Tuesday (Vertical Text) Background Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#ff780a',
      ]
    );
    $this->add_control(
      'Wednesday_color',
      [
        'label' => esc_html__( 'Wednesday (Vertical Text) Background Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#c96bb6',
      ]
    );
    $this->add_control(
      'Thursday_color',
      [
        'label' => esc_html__( 'Thursday (Vertical Text) Background Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#00ff36',
      ]
    );
    $this->add_control(
      'Friday_color',
      [
        'label' => esc_html__( 'Friday (Vertical Text) Background Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#ff00a8',
      ]
    );
    $this->add_control(
      'Saturday_color',
      [
        'label' => esc_html__( 'Saturday (Vertical Text) Background Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#008aff',
      ]
    );
    $this->add_control(
      'eventDaysColor',
      [
        'label' => esc_html__( 'Event Days (Vertical Text) Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#FFFFFF',
      ]
    );
    $this->add_control(
      'use24HoursFormat',
      [
        'label' => esc_html__( 'Use 24 Hours Format', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
        'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
        'return_value' => 'true',
        'default' => 'false',
      ]
    );
    $this->add_control(
      'noEventsAvailableText',
      [
        'label' => esc_html__( 'Translate: No Events Available', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'No event available for this month',
      ]
    );
    $this->add_control(
      'eventCancelledText',
      [
        'label' => esc_html__( 'Translate: Cancelled', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'Cancelled',
      ]
    );
    $this->add_control(
      'bookNowText',
      [
        'label' => esc_html__( 'Translate: Book Now', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'Book Now',
      ]
    );
    $this->add_control(
			'bookNowLinkTarget',
			[
				'label' => __( 'Book Now Link Target', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '_self',
				'options' => [
					'_blank'  => __( 'New Window', 'elementor-eventzilla' ),
					'_self' => __( 'The Same Window', 'elementor-eventzilla' ),
				],
			]
		);
    $this->add_control(
      'endedText',
      [
        'label' => esc_html__( 'Translate "Ended" Text', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'Ended',
      ]
    );

    $this->end_controls_section();




    $this->start_controls_section(
      'left_side_top_content',
      [
        'label' => esc_html__( 'Left Side/Top Callendar', 'elementor-eventzilla' ),
      ]
    );

    $this->add_control(
      'fullCalendarOnLeft',
      [
        'label' => esc_html__( 'Show Full Calendar On Left', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
        'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
        'return_value' => 'true',
        'default' => 'true',
      ]
    );
    $this->add_control(
      'months_area_color',
      [
        'label' => esc_html__( 'Left Side/Top Months Area Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#FFFFFF',
      ]
    );
    $this->add_control(
      'leftSideCalendarDaysColor',
      [
        'label' => esc_html__( 'Left Side Calendar Days Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#707275',
      ]
    );
    $this->add_control(
      'leftSideCalendarPastMonthDaysColor',
      [
        'label' => esc_html__( 'Left Side Calendar Past Month Days Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#aaaaaa',
      ]
    );
    $this->add_control(
      'leftSideCalendarNextMonthDaysColor',
      [
        'label' => esc_html__( 'Left Side Calendar Next Month Days Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#aaaaaa',
      ]
    );
    $this->add_control(
      'leftSideCalendarCurrentDayColor',
      [
        'label' => esc_html__( 'Left Side Calendar Current Day Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#00ffe0',
      ]
    );
    $this->add_control(
      'leftSideCalendarEventDaysColor',
      [
        'label' => esc_html__( 'Left Side Calendar Event Days Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#0000CC',
      ]
    );
    $this->add_control(
      'leftSideCalendarEventDaysBgColor',
      [
        'label' => esc_html__( 'Left Side Calendar Event Days Bg Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => true,
        'default' => '#00ffe0',
      ]
    );
    $this->add_control(
      'leftSideCalendarDaysNameColor',
      [
        'label' => esc_html__( 'Left Side Calendar Days Name Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#000000',
      ]
    );
    $this->add_control(
      'yearColor',
      [
        'label' => esc_html__( 'Year Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#a3a3a3',
      ]
    );
    $this->add_control(
      'monthColor',
      [
        'label' => esc_html__( 'Month Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#444444',
      ]
    );
    $this->add_control(
      'monthYearLineSeparatorColor',
      [
        'label' => esc_html__( 'Month Year Line Separator Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#da0000',
      ]
    );
    $this->add_control(
      'monthsNextPrevArrowsColor',
      [
        'label' => esc_html__( 'Months Next Prev Arrows Color', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Core\Schemes\Color::get_type(),
          'value' => \Elementor\Core\Schemes\Color::COLOR_1,
        ],
        'alpha' => false,
        'label_block' => false,
        'default' => '#d1d1d1',
      ]
    );

    $this->end_controls_section();


    $this->start_controls_section(
      'details_area_content',
      [
        'label' => esc_html__( 'Details Area', 'elementor-eventzilla' ),
      ]
    );

    $this->add_control(
      'detailsTitle',
      [
        'label' => esc_html__( 'Translate "Details" Title', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'Details',
      ]
    );
    $this->add_control(
      'whenWhereTitle',
      [
        'label' => esc_html__( 'Translate "When Where" Title', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'When & Where',
      ]
    );
    $this->add_control(
      'organizerTitle',
      [
        'label' => esc_html__( 'Translate "Organizer" Title', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'Organizer',
      ]
    );
    $this->add_control(
      'moreDetailsText',
      [
        'label' => esc_html__( 'Translate "More Details" Title', 'elementor-eventzilla' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'more details here',
      ]
    );
    $this->add_control(
      'showFacebookBut',
      [
        'label' => esc_html__( 'Show Facebook But', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
        'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
        'return_value' => 'true',
        'default' => 'true',
      ]
    );
    $this->add_control(
      'showTwitterBut',
      [
        'label' => esc_html__( 'Show Twitter But', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
        'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
        'return_value' => 'true',
        'default' => 'true',
      ]
    );
    $this->add_control(
      'showPinterestBut',
      [
        'label' => esc_html__( 'Show Pinterest But', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
        'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
        'return_value' => 'true',
        'default' => 'true',
      ]
    );

    $this->end_controls_section();



    /*playlist controls*/
    $this->start_controls_section(
      'playlist_content',
      [
        'label' => esc_html__( 'Events List', 'elementor-eventzilla' ),
      ]
    );


    $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'xtitle', [
				'label' => __( 'Event Title', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '',
			]
		);
    $repeater->add_control(
			'xstartdate', [
				'label' => __( 'Event Start Date', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::DATE_TIME,
        'picker_options' => array(
            'dateFormat' => 'm/d/Y-H:i',
            'time_24hr' => true,
            'enableTime' => true,
        ),
        'label_block' => true,
        'default' => '',
        'description' => esc_html__( 'click the box to select the event start date', 'elementor-eventzilla' ),
			]
		);
    $repeater->add_control(
      'xenddate', [
        'label' => __( 'Event End Date', 'elementor-eventzilla' ),
        'type' => \Elementor\Controls_Manager::DATE_TIME,
        'picker_options' => array(
            'dateFormat' => 'm/d/Y-H:i',
            'time_24hr' => true,
            'enableTime' => true,
        ),
        'label_block' => true,
        'default' => '',
        'description' => esc_html__( 'click the box to select the event end date', 'elementor-eventzilla' ),
      ]
    );
    $repeater->add_control(
			'xaddress', [
				'label' => __( 'Event Address', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '',
			]
		);
    $repeater->add_control(
		'xmainimage',
		[
			'label' => esc_html__( 'Event Main Image', 'elementor-eventzilla' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
			]
		]
	  );
    $repeater->add_control(
			'xdetails', [
				'label' => __( 'Event Details', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
        'label_block' => true,
        'default' => '',
			]
		);
    $repeater->add_control(
			'xbooknowlink', [
				'label' => __( 'Book Now Link', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '',
			]
		);
    $repeater->add_control(
		'xorganizer_logo',
		[
			'label' => esc_html__( 'Event Organizer Logo', 'elementor-eventzilla' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
			]
		]
	  );
    $repeater->add_control(
			'xorganizer_info', [
				'label' => __( 'Event Organizer Info', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
        'label_block' => true,
        'default' => '',
			]
		);
    $repeater->add_control(
			'xmoreinfolink', [
				'label' => __( 'The url to the event page', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '',
        'description' => esc_html__( 'Used for sharing', 'elementor-eventzilla' ),
			]
		);
    $repeater->add_control(
			'xdresscode', [
				'label' => __( 'Dress Code', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '',
			]
		);
    $repeater->add_control(
			'xcancelled',
			[
				'label' => esc_html__( 'Event Cancelled', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elementor-eventzilla' ),
				'label_off' => esc_html__( 'No', 'elementor-eventzilla' ),
				'return_value' => 'true',
				'default' => 'false',
			]
		);



    $this->add_control(
			'list',
			[
				'label' => __( 'Here you can add/edit/delete/clone this calendar events', 'elementor-eventzilla' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'xtitle' => __( 'Event #1', 'elementor-eventzilla' ),
					],
				],
				'title_field' => '{{{ xtitle }}}',
			]
		);


    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.1.0
   *
   * @access protected
   */
  protected function render() {
    $pathToAjaxFiles_aux=plugin_dir_url(__FILE__).'evento/';
    $rand_id=rand(10,999999);
    $settings = $this->get_settings_for_display();

    $currentY=date("Y");
    $currentM=date("n");
    $currentD=date("j");
    $currentH=date("H");
    $currentMin=date("i");
    $currentS=date("s");
    ?>
    <script>
  		jQuery(function() {
          setTimeout(function(){
                jQuery("#lbg_evento_<?php echo $rand_id; ?>").lbg_evento({
                  nowDate:"<?php echo $currentY; ?> / <?php echo $currentM; ?> / <?php echo $currentD; ?> - <?php echo $currentH; ?> : <?php echo $currentMin; ?>",
                  width:<?php echo $settings['width']; ?>,
                  months_area_width:170,
                  months_area_color:"<?php echo $settings['months_area_color']; ?>",
                  centerPlugin:<?php echo (($settings['centerPlugin']==='true')?'true':'false'); ?>,
                  showMonthFirstForDate:<?php echo (($settings['showMonthFirstForDate']==='true')?'true':'false'); ?>,
                  showEndDate:<?php echo (($settings['showEndDate']==='true')?'true':'false'); ?>,
                  eventsListVerticalPadding:<?php echo $settings['eventsListVerticalPadding']; ?>,
                  eventsListHorizontalPadding:<?php echo $settings['eventsListHorizontalPadding']; ?>,
                  eventTitleLeftMargin:<?php echo $settings['eventTitleLeftMargin']; ?>,
                  eventFirstDateFontSize:<?php echo $settings['eventFirstDateFontSize']; ?>,
                  eventSecondDateFontSize:<?php echo $settings['eventSecondDateFontSize']; ?>,
                  eventSecondDateMonthFontSize:<?php echo $settings['eventSecondDateMonthFontSize']; ?>,
                  eventTitleFontSize:<?php echo $settings['eventTitleFontSize']; ?>,
                  eventInitialDetailsFontSize:<?php echo $settings['eventInitialDetailsFontSize']; ?>,
                  eventBottomBorderColor:"<?php echo $settings['eventBottomBorderColor']; ?>",
                  eventBackgroundColor_odd:"<?php echo $settings['eventBackgroundColor_odd']; ?>",
                  eventBackgroundColor_even:"<?php echo $settings['eventBackgroundColor_even']; ?>",
                  eventBgDayColor_odd:"<?php echo $settings['eventBgDayColor_odd']; ?>",
                  eventBgDayColor_even:"<?php echo $settings['eventBgDayColor_even']; ?>",
                  eventDateColor_odd:"<?php echo $settings['eventDateColor_odd']; ?>",
                  eventDateColor_even:"<?php echo $settings['eventDateColor_even']; ?>",
                  eventTitleColor_odd:"<?php echo $settings['eventTitleColor_odd']; ?>",
                  eventTitleColor_even:"<?php echo $settings['eventTitleColor_even']; ?>",
                  eventInitialDetailsColor_odd:"<?php echo $settings['eventInitialDetailsColor_odd']; ?>",
                  eventInitialDetailsColor_even:"<?php echo $settings['eventInitialDetailsColor_even']; ?>",
                  dressCode:"<?php echo $settings['dressCode']; ?>",
                  dressCodeFontSize:<?php echo $settings['dressCodeFontSize']; ?>,
                  dressCodeColor_odd:"<?php echo $settings['dressCodeColor_odd']; ?>",
                  dressCodeColor_even:"<?php echo $settings['dressCodeColor_even']; ?>",
                  socialIconsColor_odd:"<?php echo $settings['socialIconsColor_odd']; ?>",
                  socialIconsColor_even:"<?php echo $settings['socialIconsColor_even']; ?>",
                  shortmonth_arr:["<?php echo $settings['shortmonth_Jan']; ?>", "<?php echo $settings['shortmonth_Feb']; ?>", "<?php echo $settings['shortmonth_Mar']; ?>", "<?php echo $settings['shortmonth_Apr']; ?>", "<?php echo $settings['shortmonth_May']; ?>", "<?php echo $settings['shortmonth_Jun']; ?>", "<?php echo $settings['shortmonth_Jul']; ?>", "<?php echo $settings['shortmonth_Aug']; ?>", "<?php echo $settings['shortmonth_Sep']; ?>", "<?php echo $settings['shortmonth_Oct']; ?>", "<?php echo $settings['shortmonth_Nov']; ?>", "<?php echo $settings['shortmonth_Dec']; ?>"],
                  longdays_arr:["<?php echo $settings['longdays_Sunday']; ?>", "<?php echo $settings['longdays_Monday']; ?>", "<?php echo $settings['longdays_Tuesday']; ?>", "<?php echo $settings['longdays_Wednesday']; ?>", "<?php echo $settings['longdays_Thursday']; ?>", "<?php echo $settings['longdays_Friday']; ?>", "<?php echo $settings['longdays_Saturday']; ?>"],
                  eventDaysBgColors_arr:["<?php echo $settings['Sunday_color']; ?>", "<?php echo $settings['Monday_color']; ?>", "<?php echo $settings['Tuesday_color']; ?>", "<?php echo $settings['Wednesday_color']; ?>", "<?php echo $settings['Thursday_color']; ?>", "<?php echo $settings['Friday_color']; ?>", "<?php echo $settings['Saturday_color']; ?>"],
                  eventDaysColor:"<?php echo $settings['eventDaysColor']; ?>",
                  use24HoursFormat:<?php echo (($settings['use24HoursFormat']==='true')?'true':'false'); ?>,
                  noEventsAvailableText:"<?php echo $settings['noEventsAvailableText']; ?>",
                  eventCancelledText:"<?php echo $settings['eventCancelledText']; ?>",
                  fullCalendarOnLeft:<?php echo (($settings['fullCalendarOnLeft']==='true')?'true':'false'); ?>,
                  leftSideCalendarDaysColor:"<?php echo $settings['leftSideCalendarDaysColor']; ?>",
                  leftSideCalendarPastMonthDaysColor:"<?php echo $settings['leftSideCalendarPastMonthDaysColor']; ?>",
                  leftSideCalendarNextMonthDaysColor:"<?php echo $settings['leftSideCalendarNextMonthDaysColor']; ?>",
                  leftSideCalendarCurrentDayColor:"<?php echo $settings['leftSideCalendarCurrentDayColor']; ?>",
                  leftSideCalendarEventDaysColor:"<?php echo $settings['leftSideCalendarEventDaysColor']; ?>",
                  leftSideCalendarEventDaysBgColor:"<?php echo $settings['leftSideCalendarEventDaysBgColor']; ?>",
                  leftSideCalendarDaysNameColor:"<?php echo $settings['leftSideCalendarDaysNameColor']; ?>",
                  yearColor:"<?php echo $settings['yearColor']; ?>",
                  monthColor:"<?php echo $settings['monthColor']; ?>",
                  monthYearLineSeparatorColor:"<?php echo $settings['monthYearLineSeparatorColor']; ?>",
                  monthsNextPrevArrowsColor:"<?php echo $settings['monthsNextPrevArrowsColor']; ?>",
                  detailsTitle:"<?php echo $settings['detailsTitle']; ?>",
                  whenWhereTitle:"<?php echo $settings['whenWhereTitle']; ?>",
                  organizerTitle:"<?php echo $settings['organizerTitle']; ?>",
                  moreDetailsText:"<?php echo $settings['moreDetailsText']; ?>",
                  showFacebookBut:<?php echo (($settings['showFacebookBut']==='true')?'true':'false'); ?>,
                  showTwitterBut:<?php echo (($settings['showTwitterBut']==='true')?'true':'false'); ?>,
                  showPinterestBut:<?php echo (($settings['showPinterestBut']==='true')?'true':'false'); ?>,
                  searchInputText:"<?php echo $settings['searchInputText']; ?>",
                  bookNowText:"<?php echo $settings['bookNowText']; ?>",
                  bookNowLinkTarget:"<?php echo $settings['bookNowLinkTarget']; ?>",
                  endedText:"<?php echo $settings['endedText']; ?>"
                });
          },100);
  		});
  	</script>
    <div id="lbg_evento_<?php echo $rand_id; ?>">
				<div class="lbg_xeventslist">
        <?php
        if ( $settings['list'] ) {
            foreach (  $settings['list'] as $item ) {
                echo '<ul>';
                    echo '<li class="xtitle">'. $item['xtitle'] .'</li>';
                    echo '<li class="xstartdate">'. $item['xstartdate'] .'</li>';
                    echo '<li class="xenddate">'. $item['xenddate'] .'</li>';
                    echo '<li class="xaddress">'. $item['xaddress'] .'</li>';
                    echo '<li class="xmainimage">'. $item['xmainimage']['url'] .'</li>';
                    echo '<li class="xdetails">'. $item['xdetails'] .'</li>';
                    echo '<li class="xbooknowlink">'. $item['xbooknowlink'] .'</li>';
                    echo '<li class="xorganizer_logo">'. $item['xorganizer_logo']['url'] .'</li>';
                    echo '<li class="xorganizer_info">'. $item['xorganizer_info'] .'</li>';
                    echo '<li class="xmoreinfolink">'. $item['xmoreinfolink'] .'</li>';
                    echo '<li class="xdresscode">'. $item['xdresscode'] .'</li>';
                    echo '<li class="xcancelled">'.(($item['xcancelled']==='true')?'1':'0').'</li>';
                echo '</ul>';
            }
        }
        ?>
        </div>
    </div>
    <?php
  }

  /**
   * Render the widget output in the editor.
   *
   * Written as a Backbone JavaScript template and used to generate the live preview.
   *
   * @since 1.1.0
   *
   * @access protected
   */
  protected function content_template() {

  }
}
