<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit46d17d6c82bb1b1ebd8a7e2e5d304fd9
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit46d17d6c82bb1b1ebd8a7e2e5d304fd9', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader();
        spl_autoload_unregister(array('ComposerAutoloaderInit46d17d6c82bb1b1ebd8a7e2e5d304fd9', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require_once __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit46d17d6c82bb1b1ebd8a7e2e5d304fd9::getInitializer($loader));
        } else {
            $map = require __DIR__ . '/autoload_namespaces.php';
            foreach ($map as $namespace => $path) {
                $loader->set($namespace, $path);
            }

            $map = require __DIR__ . '/autoload_psr4.php';
            foreach ($map as $namespace => $path) {
                $loader->setPsr4($namespace, $path);
            }

            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->register(true);

        if ($useStaticLoader) {

	        // .\\ Load classes without Guzzle if Guzzle/Utils aready loaded by other plugin
	        if ( class_exists( 'GuzzleHttp\Utils' ) ) {

		        $includeFiles = Composer\Autoload\ComposerStaticInit46d17d6c82bb1b1ebd8a7e2e5d304fd9::$filesGuzzles;

	        } else {

		        $includeFiles = Composer\Autoload\ComposerStaticInit46d17d6c82bb1b1ebd8a7e2e5d304fd9::$files;

	        }

        } else {
            $includeFiles = require __DIR__ . '/autoload_files.php';
        }
        foreach ($includeFiles as $fileIdentifier => $file) {
            composerRequire46d17d6c82bb1b1ebd8a7e2e5d304fd9($fileIdentifier, $file);
        }

        return $loader;
    }
}

function composerRequire46d17d6c82bb1b1ebd8a7e2e5d304fd9($fileIdentifier, $file)
{
    if (empty($GLOBALS['__composer_autoload_files'][$fileIdentifier])) {
        require $file;

        $GLOBALS['__composer_autoload_files'][$fileIdentifier] = true;
    }
}
