/**
 * Readabler
 * Web accessibility for Your WordPress site.
 * Exclusively on https://1.envato.market/readabler
 *
 * @encoding        UTF-8
 * @version         1.2.3
 * @copyright       (C) 2018 - 2021 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/
"use strict";let mdpReadabler=function(){let e,t={popup:document.getElementById("mdp-readabler-popup"),init:function(){"1"===e.popupDraggable&&(t.draggablePopup(),t.setPopupPosition()),document.getElementById("mdp-readabler-popup-close").addEventListener("click",t.closePopupCross),document.addEventListener("click",t.togglePopup),window.addEventListener("resize",e=>{j(t.setPopupPosition(e),300)})},setPopupPosition:function(e){let n=Y("popupTop"),a=Y("popupLeft");null!==n&&null!==a&&t.applyPopupPosition(n,a,e)},applyPopupPosition:function(e,n,a){e=this.topInBound(e),n=this.leftInBound(n),t.popup.style.top=e+"px",t.popup.style.left=n+"px",t.popup.style.transition=void 0!==a?"top 0.3s ease, left 0.3s ease":"none",V("popupTop",e),V("popupLeft",n),this.popup.removeAttribute("data-start")},topInBound:function(e){let t=Math.max(document.documentElement.clientHeight||0,window.innerHeight||0);return e<0&&(e=0),e>t-this.popup.offsetHeight&&(e=t-this.popup.offsetHeight),e},leftInBound:function(e){let n=Math.max(document.documentElement.clientWidth||0,window.innerWidth||0);return e<0&&(e=0),e>n-this.popup.offsetWidth&&(e=n-t.popup.offsetWidth),e},closePopupCross:function(e){e.preventDefault(),MicroModal.close("mdp-readabler-popup-box"),t.releaseTriggerButtons()},closePopupOverlay:function(e){const n=e.path||e.composedPath&&e.composedPath();let a=!1;if("object"==typeof n&&n.length>0){for(const e of n)if("mdp-readabler-popup"===e.id){a=!0;break}a||(MicroModal.close("mdp-readabler-popup-box"),t.releaseTriggerButtons(),document.removeEventListener("click",t.closePopupOverlay))}},togglePopup:function(n){if(void 0!==n){let e=n.target,t=null;if(!e)return;if(t=null!==e.closest("[data-readabler-trigger]")?e.closest("[data-readabler-trigger]"):e.closest(".readabler-trigger"),null===t)return;n.preventDefault()}document.getElementById("mdp-readabler-popup-box").classList.contains("mdp-is-open")?(MicroModal.close("mdp-readabler-popup-box"),t.releaseTriggerButtons()):(MicroModal.show("mdp-readabler-popup-box",{onClose:()=>{t.onClosePopup()},openClass:"mdp-is-open",disableScroll:!e.popupScroll,disableFocus:!1}),t.holdTriggerButtons(),t.setPopupPosition(),"1"===e.closeAnywhere&&document.addEventListener("click",t.closePopupOverlay))},holdTriggerButtons:function(){document.querySelectorAll("[data-readabler-trigger]").forEach(e=>{e.classList.add("mdp-opened")})},releaseTriggerButtons:function(){document.querySelectorAll("[data-readabler-trigger]").forEach(e=>{e.classList.remove("mdp-opened")});let e=document.getElementById("mdp-readabler-accessibility-statement-box");null!==e&&e.classList.contains("mdp-open")&&e.classList.remove("mdp-open")},onClosePopup:function(){t.releaseTriggerButtons()},draggablePopup:function(){let e=document.getElementById("mdp-readabler-popup-header"),n=0,a=0,o=0,i=0;function r(e){(e=e||window.event).preventDefault(),n=o-e.clientX,a=i-e.clientY,o=e.clientX,i=e.clientY;let r=t.popup.offsetTop-a,d=t.popup.offsetLeft-n;t.applyPopupPosition(r,d),V("popupTop",r.toString()),V("popupLeft",d.toString())}function d(){document.removeEventListener("mousemove",r),document.removeEventListener("mouseup",d)}e.onmousedown=function(e){if(!function(e){if("buttons"in e)return 1===e.buttons;return 1===(e.which||e.button)}(e=e||window.event))return;e.preventDefault(),o=e.clientX,i=e.clientY,document.addEventListener("mousemove",r),document.addEventListener("mouseup",d)}}},n={init:function(){n.OpenInterface(),n.focusElements(e.hotKeyMenu,'nav, [role="navigation"]'),n.focusElements(e.hotKeyHeadings,'h1, h2, h3, h4, h5, h6, [role="heading"]'),n.focusElements(e.hotKeyForms,"form:not([disabled])"),n.focusElements(e.hotKeyButtons,'button:not([disabled]), [role="button"]:not([disabled])'),n.focusElements(e.hotKeyGraphics,"img, picture, svg"),document.body.onkeydown=function(e){32===(e.keyCode||e.charCode||e.which)&&n.spacePressed(e)}},spacePressed:function(e){let t=document.activeElement;(t.classList.contains("mdp-readabler-accessibility-profile-item")||t.classList.contains("mdp-readabler-toggle-box")||t.classList.contains("mdp-readabler-color"))&&(e.preventDefault(),t.click())},OpenInterface:function(){hotkeys(e.hotKeyOpenInterface,(function(e){e.preventDefault(),t.togglePopup()}))},focusElements:function(e,t){hotkeys(e+",shift+"+e,(function(e,n){if(!document.body.classList.contains("mdp-readabler-keyboard-navigation"))return;e.preventDefault();let a=!0;n.key.startsWith("shift+")&&(a=!1),_.setFocus(t,a)}))}},a={clearResultsBtn:document.querySelector("#mdp-readabler-online-dictionary-search-close"),searchInput:document.getElementById("mdp-readabler-online-dictionary-search"),searchResultsUL:document.getElementById("mdp-readabler-online-dictionary-search-results"),init:function(){this.searchInput.addEventListener("input",e=>{j(this.searchQuery(e),800)}),this.clearResultsBtn.addEventListener("click",this.clearSearchResults)},getLang:function(){if("auto"===e.language){const e=document.querySelector("html");return e.getAttribute("lang")?e.getAttribute("lang").split("-",1)[0]:"en"}return e.language},searchQuery:function(e){let t=e.target.value;if(0===t.trim().length)return;if(t.trim().length<3)return void(this.searchResultsUL.innerHTML="");let n=encodeURI(t),a=`https://${this.getLang()}.wikipedia.org/w/api.php?action=query&format=json&utf8=&explaintext=&exlimit=3&generator=prefixsearch&prop=pageprops|extracts|extracts|description&redirects=&gpssearch=${n}&gpslimit=3&origin=*`;fetch(a).then(e=>e.json()).then(e=>{this.searchResultsUL.innerHTML="";for(let t in e.query.pages)e.query.pages.hasOwnProperty(t)&&this.addResultToList(e.query.pages[t]);this.clearResultsBtn.style.display="block"}).catch(e=>{})},addResultToList:function(t){const n=void 0!==t.description?t.description:"";let a=document.createElement("li");a.innerHTML=`\n                    <h5 class="mdp-readabler-online-dictionary-title">${t.title}</h5>\n                    <p class="mdp-readabler-online-dictionary-text">${n}</p>\n                    <a target="_blank" rel="nofollow" class="mdp-readabler-online-dictionary-link" href="https://${this.getLang()}.wikipedia.org/wiki/${t.title}">${e.LEARN_MORE_IN_WIKIPEDIA}</a>\n                    `,this.searchResultsUL.appendChild(a)},clearSearchResults:function(){a.searchInput.setAttribute("value",""),a.searchResultsUL.innerHTML="",a.clearResultsBtn.style.display="none"}},o={profiles:document.querySelectorAll("#mdp-readabler-accessibility-profiles-box .mdp-readabler-accessibility-profile-item"),init:function(){o.isProfiles&&(this.profiles.forEach(e=>e.addEventListener("click",j(this.toggleProfile,100))),this.profiles.forEach(e=>e.addEventListener("keydown",j(this.toggleProfile,100))))},toggleProfile:function(e){if("keydown"===e.type&&13!==e.keyCode)return;let t=this.closest(".mdp-readabler-accessibility-profile-item"),n=t.querySelector('input[type="checkbox"]');if(t.classList.contains("mdp-active")){t.classList.remove("mdp-active"),n.checked=!1,V(t.id,"0");let e=t.id.replace("mdp-readabler-accessibility-profile-","");e=X(e,"-"),e=e.replace("-",""),e="profile"+e,o[e](!1)}else{let e=document.querySelector("#mdp-readabler-accessibility-profiles-box .mdp-readabler-accessibility-profile-item.mdp-active");e&&e.click(),t.classList.add("mdp-active"),n.checked=!0,V(t.id,"1");let a=t.id.replace("mdp-readabler-accessibility-profile-","");a=X(a,"-"),a=a.replace("-",""),a="profile"+a,o[a](!0)}},loadSaved:function(){o.profiles.forEach(e=>{"1"===Y(e.id)&&(e.querySelector('input[type="checkbox"]').checked=!0,e.click())})},profileEpilepsy:function(e){let t="mdp-readabler-profile-epilepsy";if(e){document.body.classList.add(t);let e=document.querySelector("#mdp-readabler-action-low-saturation:not(.mdp-active)");e&&e.click();let n=document.querySelector("#mdp-readabler-action-stop-animations:not(.mdp-active)");n&&n.click()}else{document.body.classList.remove(t);let e=document.querySelector("#mdp-readabler-action-low-saturation.mdp-active");e&&e.click();let n=document.querySelector("#mdp-readabler-action-stop-animations.mdp-active");n&&n.click()}},profileVisuallyImpaired:function(e){let t="mdp-readabler-profile-visually-impaired";if(e){document.body.classList.add(t);let e=document.querySelector("#mdp-readabler-action-readable-font:not(.mdp-active)");e&&e.click();let n=document.querySelector("#mdp-readabler-action-high-saturation:not(.mdp-active)");n&&n.click()}else{document.body.classList.remove(t);let e=document.querySelector("#mdp-readabler-action-readable-font.mdp-active");e&&e.click();let n=document.querySelector("#mdp-readabler-action-high-saturation.mdp-active");n&&n.click()}},profileCognitiveDisability:function(e){let t="mdp-readabler-profile-cognitive-disability";if(e){document.body.classList.add(t);let e=document.querySelector("#mdp-readabler-action-highlight-titles:not(.mdp-active)");e&&e.click();let n=document.querySelector("#mdp-readabler-action-highlight-links:not(.mdp-active)");n&&n.click();let a=document.querySelector("#mdp-readabler-action-stop-animations:not(.mdp-active)");a&&a.click()}else{document.body.classList.remove(t);let e=document.querySelector("#mdp-readabler-action-highlight-titles.mdp-active");e&&e.click();let n=document.querySelector("#mdp-readabler-action-highlight-links.mdp-active");n&&n.click();let a=document.querySelector("#mdp-readabler-action-stop-animations.mdp-active");a&&a.click()}},profileAdhdFriendly:function(e){let t="mdp-readabler-profile-adhd-friendly";if(e){document.body.classList.add(t);let e=document.querySelector("#mdp-readabler-action-high-saturation:not(.mdp-active)");e&&e.click();let n=document.querySelector("#mdp-readabler-action-stop-animations:not(.mdp-active)");n&&n.click();let a=document.querySelector("#mdp-readabler-action-reading-mask:not(.mdp-active)");a&&a.click()}else{document.body.classList.remove(t);let e=document.querySelector("#mdp-readabler-action-high-saturation.mdp-active");e&&e.click();let n=document.querySelector("#mdp-readabler-action-stop-animations.mdp-active");n&&n.click();let a=document.querySelector("#mdp-readabler-action-reading-mask.mdp-active");a&&a.click()}},profileBlindUsers:function(e){let t="mdp-readabler-profile-blind-users";if(e){document.body.classList.add(t);let e=document.querySelector("#mdp-readabler-action-readable-font:not(.mdp-active)");e&&e.click();let n=document.querySelector("#mdp-readabler-action-virtual-keyboard:not(.mdp-active)");n&&n.click();let a=document.querySelector("#mdp-readabler-action-text-to-speech:not(.mdp-active)");a&&a.click();let o=document.querySelector("#mdp-readabler-action-keyboard-navigation:not(.mdp-active)");o&&o.click()}else{document.body.classList.remove(t);let e=document.querySelector("#mdp-readabler-action-readable-font.mdp-active");e&&e.click();let n=document.querySelector("#mdp-readabler-action-virtual-keyboard.mdp-active");n&&n.click();let a=document.querySelector("#mdp-readabler-action-text-to-speech.mdp-active");a&&a.click();let o=document.querySelector("#mdp-readabler-action-keyboard-navigation.mdp-active");o&&o.click()}},isProfiles:function(){return!!(e.profileEpilepsy||e.profileVisuallyImpaired||e.profileCognitiveDisability||e.profileAdhdFriendly||e.profileBlindUsers)}},i={init:function(){let e=document.querySelectorAll(".mdp-readabler-input-spinner-box .mdp-readabler-plus");e.forEach(e=>e.addEventListener("click",e=>i.step(e)));let t,n=document.querySelectorAll(".mdp-readabler-input-spinner-box .mdp-readabler-minus");n.forEach(e=>e.addEventListener("click",e=>i.step(e))),e.forEach(e=>e.addEventListener("mousedown",e=>{t=setInterval((function(){i.step(e)}),500)})),e.forEach(e=>e.addEventListener("mouseup",()=>{clearInterval(t)})),e.forEach(e=>e.addEventListener("mouseleave",()=>{clearInterval(t)})),n.forEach(e=>e.addEventListener("mousedown",e=>{t=setInterval((function(){i.step(e)}),500)})),n.forEach(e=>e.addEventListener("mouseup",()=>{clearInterval(t)})),n.forEach(e=>e.addEventListener("mouseleave",()=>{clearInterval(t)}))},step:function(e){let t=e.target.closest(".mdp-readabler-control").querySelector(".mdp-readabler-value"),n=parseInt(t.dataset.value),a=parseInt(e.target.closest(".mdp-readabler-input-spinner-box").dataset.step);e.target.classList.contains("mdp-readabler-minus")?n-=a:n+=a,t.dataset.value=n.toString(),i.setLabel(t,n),V(e.target.closest(".mdp-readabler-action-box").id,t.dataset.value);const o=new CustomEvent("ReadablerInputSpinnerChanged",{});t.dispatchEvent(o)},setLabel:function(t,n){if(0===(n=parseInt(n)))t.innerHTML=e.DEFAULT;else{let e=n>0?"+":"";t.innerHTML=e+n+"%"}},loadSaved:function(){document.querySelectorAll(".mdp-readabler-spinner-box").forEach(e=>{let t=Y(e.id);if(!t)return;if(t=parseInt(t),0===t)return;let n=e.querySelector(".mdp-readabler-value");n.dataset.value=t.toString(),i.setLabel(n,t);const a=new CustomEvent("ReadablerInputSpinnerChanged",{});n.dispatchEvent(a)})}},r={init:function(){let e=document.querySelectorAll(".mdp-readabler-toggle-box");e.forEach(e=>e.addEventListener("click",e=>r.toggle(e))),e.forEach(e=>e.addEventListener("keydown",e=>r.toggle(e)))},toggle:function(e){if("keydown"===e.type&&13!==e.keyCode)return;let t=e.target.closest(".mdp-readabler-toggle-box");t.classList.toggle("mdp-active"),V(t.id,t.classList.contains("mdp-active"));const n=new CustomEvent("ReadablerToggleBoxChanged",{});t.dispatchEvent(n)},loadSaved:function(){document.querySelectorAll(".mdp-readabler-toggle-box").forEach(e=>{"true"===Y(e.id)&&e.click()})}},d={init:function(){let e=document.querySelectorAll(".mdp-readabler-palette-box");e.forEach(e=>e.addEventListener("click",e=>d.selectColor(e))),e.forEach(e=>e.addEventListener("keydown",e=>d.selectColor(e)))},selectColor:function(e){if("keydown"===e.type&&13!==e.keyCode)return;if(!e.target.classList.contains("mdp-readabler-color"))return;let t=e.target.closest(".mdp-readabler-palette-box");if(e.target.classList.contains("mdp-active"))e.target.classList.remove("mdp-active"),d.firePaletteChange(t,null);else{let n=t.querySelector(".mdp-readabler-color.mdp-active");null!==n&&n.classList.remove("mdp-active"),e.target.classList.add("mdp-active"),d.firePaletteChange(t,e.target.dataset.color),V(e.target.closest(".mdp-readabler-palette-box").id,e.target.dataset.color)}},loadSaved:function(){document.querySelectorAll(".mdp-readabler-palette-box").forEach(e=>{let t=Y(e.id);null!==t&&e.querySelectorAll(".mdp-readabler-color").forEach(e=>{e.dataset.color===t&&e.click()})})},firePaletteChange:function(e,t){const n=new CustomEvent("ReadablerPaletteChanged",{detail:{color:t}});e.dispatchEvent(n)}},l={init:function(){document.querySelector("#mdp-readabler-action-content-scaling .mdp-readabler-value").addEventListener("ReadablerInputSpinnerChanged",this.scaleContent)},scaleContent:function(e){let t=parseInt(e.target.dataset.value);navigator.userAgent.toLowerCase().indexOf("firefox")>0?l.setFirefoxProperty(t,"body","-moz-transform",""):l.setElementProperty(t,"body > *","zoom","")},setFirefoxProperty:function(e,t,n,a){let o=X(n,"-").replace("-","");o="readabler"+o;let i=document.querySelector(t),r=parseFloat(i.dataset[o]);if(!r||isNaN(r)){let e=window.getComputedStyle(i,null).getPropertyValue(n);r="none"===e?1:parseFloat(e.split("(")[1].split(")")[0]),i.dataset[o]=r.toString()}0===r&&(r=1);let d=(r+Math.abs(r/100)*e).toFixed(2);1===parseFloat(d)?(i.style.setProperty(n,"none","important"),i.style.removeProperty("-moz-transform-origin")):(i.style.setProperty(n,`scale(${d.toString()})`,"important"),i.style.setProperty("-moz-transform-origin","top left","important"))},setElementProperty:function(e,t,n,a){let o=X(n,"-").replace("-","");o="readabler"+o,document.querySelectorAll(t).forEach(t=>{let i=parseFloat(t.dataset[o]);if(!i){let e=window.getComputedStyle(t,null).getPropertyValue(n);i=parseFloat(e),"normal"===e&&(i=0),t.dataset[o]=i.toString()}0===i&&(i=1);let r=(i+Math.abs(i/100)*e).toFixed(2);t.style.setProperty(n,r.toString()+a,"important")})}},s={fontSizingStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-font-sizing .mdp-readabler-value").addEventListener("ReadablerInputSpinnerChanged",this.fontSizing)},fontScaling:function(e,t){for(let n of e)if(document.getElementsByTagName(n).length>0)for(let e of document.getElementsByTagName(n)){let n=window.getComputedStyle(e).fontSize.split("px",1)[0];null===e.getAttribute("original-size")?e.setAttribute("original-size",n):n=e.getAttribute("original-size"),e.style.fontSize=parseInt(n)+n*(.01*t)+"px"}},fontSizing:function(e){let t=parseInt(e.target.dataset.value);0!==t?(document.body.classList.add("mdp-readabler-font-sizing"),s.fontScaling(["h1","h2","h3","h4","h5","h6","p","span","p","a","li","label","input","select","textarea","legend","code","pre","dd","dt","span","blockquote"],t)):document.body.classList.remove("mdp-readabler-font-sizing")}},c={lineHeightStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-line-height .mdp-readabler-value").addEventListener("ReadablerInputSpinnerChanged",this.lineHeight)},fontLeading:function(e,t){for(let n of e)if(document.getElementsByTagName(n).length>0)for(let e of document.getElementsByTagName(n)){let n=window.getComputedStyle(e).lineHeight.split("px",1)[0];null===e.getAttribute("original-leading")?e.setAttribute("original-leading",n):n=e.getAttribute("original-leading"),e.style.lineHeight=parseInt(n)+n*(.01*t)+"px"}},lineHeight:function(e){let t=parseInt(e.target.dataset.value);0!==t?(document.body.classList.add("mdp-readabler-line-height"),c.fontLeading(["h1","h2","h3","h4","h5","h6","p","span","p","a","li","label","input","select","textarea","legend","code","pre","dd","dt","span","blockquote"],t)):document.body.classList.remove("mdp-readabler-line-height")}},p={letterSpacingStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-letter-spacing .mdp-readabler-value").addEventListener("ReadablerInputSpinnerChanged",this.letterSpacing)},letterSpacing:function(e){let t=parseInt(e.target.dataset.value);if(0===t)return void document.body.classList.remove("mdp-readabler-letter-spacing");document.body.classList.add("mdp-readabler-letter-spacing");let n=t/100;p.letterSpacingStyle.innerHTML=`\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-letter-spacing,\n                body.mdp-readabler-letter-spacing h1,\n                body.mdp-readabler-letter-spacing h1 span,\n                body.mdp-readabler-letter-spacing h2,\n                body.mdp-readabler-letter-spacing h2 span,\n                body.mdp-readabler-letter-spacing h3,\n                body.mdp-readabler-letter-spacing h3 span,\n                body.mdp-readabler-letter-spacing h4,\n                body.mdp-readabler-letter-spacing h4 span,\n                body.mdp-readabler-letter-spacing h5,\n                body.mdp-readabler-letter-spacing h5 span,\n                body.mdp-readabler-letter-spacing h6,\n                body.mdp-readabler-letter-spacing h6 span,\n                \n                body.mdp-readabler-letter-spacing p,\n                body.mdp-readabler-letter-spacing li,\n                body.mdp-readabler-letter-spacing label,\n                body.mdp-readabler-letter-spacing input,\n                body.mdp-readabler-letter-spacing select,\n                body.mdp-readabler-letter-spacing textarea,\n                body.mdp-readabler-letter-spacing legend,\n                body.mdp-readabler-letter-spacing code,\n                body.mdp-readabler-letter-spacing pre,\n                body.mdp-readabler-letter-spacing dd,\n                body.mdp-readabler-letter-spacing dt,\n                body.mdp-readabler-letter-spacing span,\n                body.mdp-readabler-letter-spacing blockquote {\n                    letter-spacing: ${n}px !important;    \n                }\n            `,document.head.appendChild(p.letterSpacingStyle)}},u={readableFontStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-readable-font").addEventListener("ReadablerToggleBoxChanged",u.readableFont)},readableFont:function(e){e.target.classList.contains("mdp-active")?(u.disableOthers(),document.body.classList.add("mdp-readabler-readable-font"),u.readableFontStyle.innerHTML="\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-readable-font *:not(i){\n                    font-family: Arial, Helvetica, sans-serif !important;\n                }\n            ",document.head.appendChild(u.readableFontStyle)):document.body.classList.remove("mdp-readabler-readable-font")},disableOthers:function(){let e=document.getElementById("mdp-readabler-action-dyslexia-font");e&&e.classList.contains("mdp-active")&&e.click()}},m={dyslexiaFriendlyStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-dyslexia-font").addEventListener("ReadablerToggleBoxChanged",m.dyslexiaFriendly)},dyslexiaFriendly:function(t){t.target.classList.contains("mdp-active")?(m.disableOthers(),document.body.classList.add("mdp-readabler-dyslexia-font"),m.dyslexiaFriendlyStyle.innerHTML=`\n                /*noinspection CssUnknownTarget*/\n                @font-face {\n                    font-family: 'OpenDyslexic';\n                    src: url("${e.pluginURL}fonts/OpenDyslexic-Italic.eot");\n                    src: local("OpenDyslexic Italic"), local("OpenDyslexic-Italic"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Italic.eot?#iefix") format("embedded-opentype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Italic.woff2") format("woff2"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Italic.woff") format("woff"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Italic.ttf") format("truetype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Italic.svg#OpenDyslexic-Italic") format("svg");\n                    font-weight: normal;\n                    font-style: italic;\n                    font-display: swap; \n                }\n\n                /*noinspection CssUnknownTarget*/\n                @font-face {\n                    font-family: 'OpenDyslexic';\n                    src: url("${e.pluginURL}fonts/OpenDyslexic-BoldItalic.eot");\n                    src: local("OpenDyslexic Bold Italic"), local("OpenDyslexic-BoldItalic"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-BoldItalic.eot?#iefix") format("embedded-opentype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-BoldItalic.woff2") format("woff2"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-BoldItalic.woff") format("woff"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-BoldItalic.ttf") format("truetype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-BoldItalic.svg#OpenDyslexic-BoldItalic") format("svg");\n                    font-weight: bold;\n                    font-style: italic;\n                    font-display: swap; \n                }\n\n                /*noinspection CssUnknownTarget*/\n                @font-face {\n                    font-family: 'OpenDyslexic';\n                    src: url("${e.pluginURL}fonts/OpenDyslexic-Bold.eot");\n                    src: local("OpenDyslexic Bold"), local("OpenDyslexic-Bold"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Bold.eot?#iefix") format("embedded-opentype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Bold.woff2") format("woff2"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Bold.woff") format("woff"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Bold.ttf") format("truetype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Bold.svg#OpenDyslexic-Bold") format("svg");\n                    font-weight: bold;\n                    font-style: normal;\n                    font-display: swap; \n                }\n\n                /*noinspection CssUnknownTarget*/\n                @font-face {\n                    font-family: 'OpenDyslexic';\n                    src: url("${e.pluginURL}fonts/OpenDyslexic-Regular.eot");\n                    src: local("OpenDyslexic Regular"), local("OpenDyslexic-Regular"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Regular.eot?#iefix") format("embedded-opentype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Regular.woff2") format("woff2"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Regular.woff") format("woff"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Regular.ttf") format("truetype"), \n                         url("${e.pluginURL}fonts/OpenDyslexic-Regular.svg#OpenDyslexic-Regular") format("svg");\n                    font-weight: normal;\n                    font-style: normal;\n                    font-display: swap; \n                }\n                    \n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-dyslexia-font,\n                body.mdp-readabler-dyslexia-font h1,\n                body.mdp-readabler-dyslexia-font h1 span,\n                body.mdp-readabler-dyslexia-font h2,\n                body.mdp-readabler-dyslexia-font h2 span,\n                body.mdp-readabler-dyslexia-font h3,\n                body.mdp-readabler-dyslexia-font h3 span,\n                body.mdp-readabler-dyslexia-font h4,\n                body.mdp-readabler-dyslexia-font h4 span,\n                body.mdp-readabler-dyslexia-font h5,\n                body.mdp-readabler-dyslexia-font h5 span,\n                body.mdp-readabler-dyslexia-font h6,\n                body.mdp-readabler-dyslexia-font h6 span,\n\n                body.mdp-readabler-dyslexia-font a,\n                body.mdp-readabler-dyslexia-font p,\n                body.mdp-readabler-dyslexia-font li a,\n                body.mdp-readabler-dyslexia-font label,\n                body.mdp-readabler-dyslexia-font input,\n                body.mdp-readabler-dyslexia-font select,\n                body.mdp-readabler-dyslexia-font textarea,\n                body.mdp-readabler-dyslexia-font legend,\n                body.mdp-readabler-dyslexia-font code,\n                body.mdp-readabler-dyslexia-font pre,\n                body.mdp-readabler-dyslexia-font dd,\n                body.mdp-readabler-dyslexia-font dt,\n                body.mdp-readabler-dyslexia-font span,\n                body.mdp-readabler-dyslexia-font blockquote {\n                    font-family: 'OpenDyslexic', serif !important;\n                }\n            `,document.head.appendChild(m.dyslexiaFriendlyStyle)):document.body.classList.remove("mdp-readabler-dyslexia-font")},disableOthers:function(){let e=document.getElementById("mdp-readabler-action-readable-font");e.classList.contains("mdp-active")&&e.click()}},b={highlightTitlesStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-highlight-titles").addEventListener("ReadablerToggleBoxChanged",b.highlightTitles)},highlightTitles:function(t){t.target.classList.contains("mdp-active")?(document.body.classList.add("mdp-readabler-highlight-titles"),b.highlightTitlesStyle.innerHTML=`                    \n                body.mdp-readabler-highlight-titles h1, \n                body.mdp-readabler-highlight-titles h2, \n                body.mdp-readabler-highlight-titles h3, \n                body.mdp-readabler-highlight-titles h4, \n                body.mdp-readabler-highlight-titles h5, \n                body.mdp-readabler-highlight-titles h6, \n                body.mdp-readabler-highlight-titles [role="heading"] {\n                    outline-style: ${e.highlightTitlesStyle} !important;\n                    outline-color: ${e.highlightTitlesColor} !important;\n                    outline-width: ${e.highlightTitlesWidth}px !important;\n                    outline-offset: ${e.highlightTitlesOffset}px !important;\n                }\n            `,document.head.appendChild(b.highlightTitlesStyle)):document.body.classList.remove("mdp-readabler-highlight-titles")}},g={highlightLinksStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-highlight-links").addEventListener("ReadablerToggleBoxChanged",g.highlightLinks)},highlightLinks:function(t){t.target.classList.contains("mdp-active")?(document.body.classList.add("mdp-readabler-highlight-links"),g.highlightLinksStyle.innerHTML=`                    \n                body.mdp-readabler-highlight-links a {\n                    outline-style: ${e.highlightLinksStyle} !important;\n                    outline-color: ${e.highlightLinksColor} !important;\n                    outline-width: ${e.highlightLinksWidth}px !important;\n                    outline-offset: ${e.highlightLinksOffset}px !important;\n                }\n            `,document.head.appendChild(g.highlightLinksStyle)):document.body.classList.remove("mdp-readabler-highlight-links")}},h={tooltip:document.createElement("div"),textMagnifierStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-text-magnifier").addEventListener("ReadablerToggleBoxChanged",h.textMagnifier),h.tooltip.id="mdp-readabler-text-magnifier-tooltip"},textMagnifier:function(t){if(!t.target.classList.contains("mdp-active"))return document.body.classList.remove("mdp-readabler-text-magnifier"),document.removeEventListener("mousemove",h.updateTooltip,!1),document.body.removeChild(h.tooltip),document.removeEventListener("mouseleave",h.hideTooltip,!1),void document.removeEventListener("mouseenter",h.showTooltip,!1);document.body.classList.add("mdp-readabler-text-magnifier"),document.body.appendChild(h.tooltip),document.addEventListener("mousemove",h.updateTooltip,!1),document.addEventListener("mouseleave",h.hideTooltip,!1),document.addEventListener("mouseenter",h.showTooltip,!1),h.textMagnifierStyle.innerHTML=`\n                /*noinspection CssUnusedSymbol*/                    \n                body.mdp-readabler-text-magnifier #mdp-readabler-text-magnifier-tooltip {\n                    background-color: ${e.textMagnifierBgColor} !important;\n                    color: ${e.textMagnifierColor} !important;\n                    font-size: ${e.textMagnifierFontSize}px !important;\n                }\n            `,document.head.appendChild(h.textMagnifierStyle)},updateTooltip:function(e){if(!["H1","H2","H3","H4","H5","H6","SPAN","P","LI","LABEL","INPUT","SELECT","TEXTAREA","LEGEND","CODE","PRE","DD","DT","A","STRONG","B","BLOCKQUOTE"].includes(e.target.nodeName))return void h.hideTooltip();if(""===e.target.innerText.trim())return void h.hideTooltip();h.showTooltip(),h.tooltip.innerHTML=e.target.innerText;let t=window.innerWidth;h.tooltip.style.top=e.clientY+15+"px",e.clientX>.5*window.innerWidth?(t=e.clientX-15<=680?e.clientX-15:680,h.tooltip.style.left="unset",h.tooltip.style.right=window.innerWidth-e.clientX-15+"px",h.tooltip.style.maxWidth=t+"px"):(t=window.innerWidth-e.clientX-45<680?window.innerWidth-e.clientX-45:680,h.tooltip.style.right="unset",h.tooltip.style.left=e.clientX+15+"px",h.tooltip.style.maxWidth=t+"px")},hideTooltip:function(){h.tooltip.style.visibility="hidden"},showTooltip:function(){h.tooltip.style.visibility="visible"}},y={alignCenterStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-align-center").addEventListener("ReadablerToggleBoxChanged",y.alignCenter)},alignCenter:function(e){e.target.classList.contains("mdp-active")?(y.disableOthers(),document.body.classList.add("mdp-readabler-align-center"),y.alignCenterStyle.innerHTML="\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-align-center,\n                body.mdp-readabler-align-center h1,\n                body.mdp-readabler-align-center h1 span,\n                body.mdp-readabler-align-center h2,\n                body.mdp-readabler-align-center h2 span,\n                body.mdp-readabler-align-center h3,\n                body.mdp-readabler-align-center h3 span,\n                body.mdp-readabler-align-center h4,\n                body.mdp-readabler-align-center h4 span,\n                body.mdp-readabler-align-center h5,\n                body.mdp-readabler-align-center h5 span,\n                body.mdp-readabler-align-center h6,\n                body.mdp-readabler-align-center h6 span,\n\n                body.mdp-readabler-align-center p,\n                body.mdp-readabler-align-center li,\n                body.mdp-readabler-align-center label,\n                body.mdp-readabler-align-center input,\n                body.mdp-readabler-align-center select,\n                body.mdp-readabler-align-center textarea,\n                body.mdp-readabler-align-center legend,\n                body.mdp-readabler-align-center code,\n                body.mdp-readabler-align-center pre,\n                body.mdp-readabler-align-center dd,\n                body.mdp-readabler-align-center dt,\n                body.mdp-readabler-align-center span,\n                body.mdp-readabler-align-center blockquote {\n                    text-align: center !important;\n                }\n            ",document.head.appendChild(y.alignCenterStyle)):document.body.classList.remove("mdp-readabler-align-center")},disableOthers:function(){let e=document.getElementById("mdp-readabler-action-align-left");null!==e&&e.classList.contains("mdp-active")&&e.click();let t=document.getElementById("mdp-readabler-action-align-right");null!==t&&t.classList.contains("mdp-active")&&t.click()}},f={alignLeftStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-align-left").addEventListener("ReadablerToggleBoxChanged",f.alignLeft)},alignLeft:function(e){e.target.classList.contains("mdp-active")?(f.disableOthers(),document.body.classList.add("mdp-readabler-align-left"),f.alignLeftStyle.innerHTML="\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-align-left,\n                body.mdp-readabler-align-left h1,\n                body.mdp-readabler-align-left h1 span,\n                body.mdp-readabler-align-left h2,\n                body.mdp-readabler-align-left h2 span,\n                body.mdp-readabler-align-left h3,\n                body.mdp-readabler-align-left h3 span,\n                body.mdp-readabler-align-left h4,\n                body.mdp-readabler-align-left h4 span,\n                body.mdp-readabler-align-left h5,\n                body.mdp-readabler-align-left h5 span,\n                body.mdp-readabler-align-left h6,\n                body.mdp-readabler-align-left h6 span,\n\n                body.mdp-readabler-align-left p,\n                body.mdp-readabler-align-left li,\n                body.mdp-readabler-align-left label,\n                body.mdp-readabler-align-left input,\n                body.mdp-readabler-align-left select,\n                body.mdp-readabler-align-left textarea,\n                body.mdp-readabler-align-left legend,\n                body.mdp-readabler-align-left code,\n                body.mdp-readabler-align-left pre,\n                body.mdp-readabler-align-left dd,\n                body.mdp-readabler-align-left dt,\n                body.mdp-readabler-align-left span,\n                body.mdp-readabler-align-left blockquote {\n                    text-align: left !important;\n                }\n            ",document.head.appendChild(f.alignLeftStyle)):document.body.classList.remove("mdp-readabler-align-left")},disableOthers:function(){let e=document.getElementById("mdp-readabler-action-align-center");null!==e&&e.classList.contains("mdp-active")&&e.click();let t=document.getElementById("mdp-readabler-action-align-right");null!==t&&t.classList.contains("mdp-active")&&t.click()}},v={alignRightStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-align-right").addEventListener("ReadablerToggleBoxChanged",v.alignRight)},alignRight:function(e){e.target.classList.contains("mdp-active")?(v.disableOthers(),document.body.classList.add("mdp-readabler-align-right"),v.alignRightStyle.innerHTML="\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-align-right,\n                body.mdp-readabler-align-right h1,\n                body.mdp-readabler-align-right h1 span,\n                body.mdp-readabler-align-right h2,\n                body.mdp-readabler-align-right h2 span,\n                body.mdp-readabler-align-right h3,\n                body.mdp-readabler-align-right h3 span,\n                body.mdp-readabler-align-right h4,\n                body.mdp-readabler-align-right h4 span,\n                body.mdp-readabler-align-right h5,\n                body.mdp-readabler-align-right h5 span,\n                body.mdp-readabler-align-right h6,\n                body.mdp-readabler-align-right h6 span,\n\n                body.mdp-readabler-align-right p,\n                body.mdp-readabler-align-right li,\n                body.mdp-readabler-align-right label,\n                body.mdp-readabler-align-right input,\n                body.mdp-readabler-align-right select,\n                body.mdp-readabler-align-right textarea,\n                body.mdp-readabler-align-right legend,\n                body.mdp-readabler-align-right code,\n                body.mdp-readabler-align-right pre,\n                body.mdp-readabler-align-right dd,\n                body.mdp-readabler-align-right dt,\n                body.mdp-readabler-align-right span,\n                body.mdp-readabler-align-right blockquote {\n                    text-align: right !important;\n                }\n            ",document.head.appendChild(v.alignRightStyle)):document.body.classList.remove("mdp-readabler-align-right")},disableOthers:function(){let e=document.getElementById("mdp-readabler-action-align-center");null!==e&&e.classList.contains("mdp-active")&&e.click();let t=document.getElementById("mdp-readabler-action-align-left");null!==t&&t.classList.contains("mdp-active")&&t.click()}},L=function(e){document.querySelectorAll("#mdp-readabler-visually-pleasing-experience-box .mdp-readabler-toggle-box.mdp-active").forEach(t=>{e.id!==t.id&&t.click()})},x={darkContrastStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-dark-contrast").addEventListener("ReadablerToggleBoxChanged",x.darkContrast)},darkContrast:function(e){e.target.classList.contains("mdp-active")?(L(e.target),document.body.classList.add("mdp-readabler-dark-contrast")):document.body.classList.remove("mdp-readabler-dark-contrast")}},k={lightContrastStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-light-contrast").addEventListener("ReadablerToggleBoxChanged",k.lightContrast)},lightContrast:function(e){e.target.classList.contains("mdp-active")?(L(e.target),document.body.classList.add("mdp-readabler-light-contrast")):document.body.classList.remove("mdp-readabler-light-contrast")}},S={init:function(){document.querySelector("#mdp-readabler-action-monochrome").addEventListener("ReadablerToggleBoxChanged",S.monochrome)},monochrome:function(e){e.target.classList.contains("mdp-active")?(L(e.target),document.body.classList.add("mdp-readabler-monochrome")):document.body.classList.remove("mdp-readabler-monochrome")}},E={init:function(){document.querySelector("#mdp-readabler-action-high-saturation").addEventListener("ReadablerToggleBoxChanged",E.highSaturation)},highSaturation:function(e){e.target.classList.contains("mdp-active")?(L(e.target),document.body.classList.add("mdp-readabler-high-saturation")):document.body.classList.remove("mdp-readabler-high-saturation")}},w={init:function(){document.querySelector("#mdp-readabler-action-high-contrast").addEventListener("ReadablerToggleBoxChanged",w.highContrast)},highContrast:function(e){e.target.classList.contains("mdp-active")?(L(e.target),document.body.classList.add("mdp-readabler-high-contrast")):document.body.classList.remove("mdp-readabler-high-contrast")}},C={init:function(){document.querySelector("#mdp-readabler-action-low-saturation").addEventListener("ReadablerToggleBoxChanged",C.lowSaturation)},lowSaturation:function(e){e.target.classList.contains("mdp-active")?(L(e.target),document.body.classList.add("mdp-readabler-low-saturation")):document.body.classList.remove("mdp-readabler-low-saturation")}},T={textColorsStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-text-colors").addEventListener("ReadablerPaletteChanged",T.textColors)},textColors:function(e){let t=e.detail.color;null!==t?(document.body.classList.add("mdp-readabler-text-colors"),T.textColorsStyle.innerHTML=`\n                body.mdp-readabler-text-colors p,\n                body.mdp-readabler-text-colors li,\n                body.mdp-readabler-text-colors label,\n                body.mdp-readabler-text-colors input,\n                body.mdp-readabler-text-colors select,\n                body.mdp-readabler-text-colors textarea,\n                body.mdp-readabler-text-colors legend,\n                body.mdp-readabler-text-colors code,\n                body.mdp-readabler-text-colors pre,\n                body.mdp-readabler-text-colors dd,\n                body.mdp-readabler-text-colors dt,\n                body.mdp-readabler-text-colors span,\n                body.mdp-readabler-text-colors blockquote {\n                    color: ${t} !important;\n                }\n            `,document.head.appendChild(T.textColorsStyle)):document.body.classList.remove("mdp-readabler-text-colors")}},R={titleColorsStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-title-colors").addEventListener("ReadablerPaletteChanged",R.titleColors)},titleColors:function(e){let t=e.detail.color;null!==t?(document.body.classList.add("mdp-readabler-title-colors"),R.titleColorsStyle.innerHTML=`\n                body.mdp-readabler-title-colors h1,\n                body.mdp-readabler-title-colors h1 *,\n                body.mdp-readabler-title-colors h2,\n                body.mdp-readabler-title-colors h2 *,\n                body.mdp-readabler-title-colors h3,\n                body.mdp-readabler-title-colors h3 *,\n                body.mdp-readabler-title-colors h4,\n                body.mdp-readabler-title-colors h4 *,\n                body.mdp-readabler-title-colors h5,\n                body.mdp-readabler-title-colors h5 *,\n                body.mdp-readabler-title-colors h6,\n                body.mdp-readabler-title-colors h6 * {\n                    color: ${t} !important;\n                }\n            `,document.head.appendChild(R.titleColorsStyle)):document.body.classList.remove("mdp-readabler-title-colors")}},q={backgroundColorsStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-background-colors").addEventListener("ReadablerPaletteChanged",q.backgroundColors)},backgroundColors:function(e){let t=e.detail.color;null!==t?(document.body.classList.add("mdp-readabler-background-colors"),q.backgroundColorsStyle.innerHTML=`\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-background-colors,\n                body.mdp-readabler-background-colors h1,\n                body.mdp-readabler-background-colors h1 span,\n                body.mdp-readabler-background-colors h2,\n                body.mdp-readabler-background-colors h2 span,\n                body.mdp-readabler-background-colors h3,\n                body.mdp-readabler-background-colors h3 span,\n                body.mdp-readabler-background-colors h4,\n                body.mdp-readabler-background-colors h4 span,\n                body.mdp-readabler-background-colors h5,\n                body.mdp-readabler-background-colors h5 span,\n                body.mdp-readabler-background-colors h6,\n                body.mdp-readabler-background-colors h6 span,\n\n                body.mdp-readabler-background-colors p,\n                body.mdp-readabler-background-colors li,\n                body.mdp-readabler-background-colors label,\n                body.mdp-readabler-background-colors input,\n                body.mdp-readabler-background-colors select,\n                body.mdp-readabler-background-colors textarea,\n                body.mdp-readabler-background-colors legend,\n                body.mdp-readabler-background-colors code,\n                body.mdp-readabler-background-colors pre,\n                body.mdp-readabler-background-colors dd,\n                body.mdp-readabler-background-colors dt,\n                body.mdp-readabler-background-colors span,\n                body.mdp-readabler-background-colors blockquote {\n                    background-color: ${t} !important;\n                }\n            `,document.head.appendChild(q.backgroundColorsStyle)):document.body.classList.remove("mdp-readabler-background-colors")}},B={init:function(){document.querySelector("#mdp-readabler-action-mute-sounds").addEventListener("ReadablerToggleBoxChanged",B.muteSounds)},muteSounds:function(e){if(!e.target.classList.contains("mdp-active"))return B.mute(!1),void document.documentElement.classList.remove("mdp-readabler-mute-sounds");B.mute(!0),document.documentElement.classList.add("mdp-readabler-mute-sounds")},mute:function(e){document.querySelectorAll("video, audio").forEach(t=>{t.muted=e}),document.querySelectorAll("iframe").forEach(t=>{if(t.src.toLowerCase().includes("youtube.com")||t.src.toLowerCase().includes("vimeo.com")){let n=new URL(t.src);e?(n.searchParams.append("mute","1"),n.searchParams.append("muted","1")):(n.searchParams.delete("mute"),n.searchParams.delete("muted")),t.src=n.href}})}},I={hideImagesStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-hide-images").addEventListener("ReadablerToggleBoxChanged",I.hideImages)},hideImages:function(e){e.target.classList.contains("mdp-active")?(document.body.classList.add("mdp-readabler-hide-images"),I.hideImagesStyle.innerHTML="\n                body.mdp-readabler-hide-images img,\n                body.mdp-readabler-hide-images video {\n                    opacity: 0 !important;\n                    visibility: hidden !important\n                }\n\n                body.mdp-readabler-hide-images * {\n                    background-image: none !important\n                }\n\n            ",document.head.appendChild(I.hideImagesStyle)):document.body.classList.remove("mdp-readabler-hide-images")}},M={keyboardBox:document.getElementById("mdp-readabler-keyboard-box"),keyboard:null,selectedInput:null,init:function(){document.querySelector("#mdp-readabler-action-virtual-keyboard").addEventListener("ReadablerToggleBoxChanged",M.virtualKeyboard),document.querySelectorAll("textarea, input[type]:not([type=radio]):not([type=checkbox]):not([type=hidden])").forEach(e=>{e.addEventListener("focus",M.onInputFocus),e.addEventListener("input",M.onInputChange)}),document.addEventListener("click",e=>{let t=e.target.nodeName.toLowerCase();null===e.target.closest("#mdp-readabler-keyboard-box")&&"input"!==t&&"textarea"!==t&&(M.keyboardBox.style.display="none")}),M.makeKeyboardDraggable()},onInputFocus:function(e){document.body.classList.contains("mdp-readabler-virtual-keyboard")&&(M.keyboardBox.style.display="block",e.target.id||(e.target.id=M.uid()),M.selectedInput="#"+e.target.id,M.keyboard.setOptions({inputName:e.target.id}))},onInputChange:function(e){document.body.classList.contains("mdp-readabler-virtual-keyboard")&&M.keyboard.setInput(e.target.value,e.target.id)},virtualKeyboard:function(t){if(!t.target.classList.contains("mdp-active"))return document.body.classList.remove("mdp-readabler-virtual-keyboard"),void M.keyboard.destroy();document.body.classList.add("mdp-readabler-virtual-keyboard");const n=(new(0,window.SimpleKeyboardLayouts.default)).get(e.virtualKeyboardLayout);M.keyboard=new window.SimpleKeyboard.default({newLineOnEnter:!0,onChange:e=>M.onChange(e),onKeyPress:e=>M.onKeyPress(e),layout:n.layout,theme:"mdp-readabler-simple-keyboard",physicalKeyboardHighlight:!0})},onChange:function(e){document.querySelector(M.selectedInput).value=e},onKeyPress:function(e){"{lock}"!==e&&"{shift}"!==e||M.handleShiftButton()},handleShiftButton:function(){let e="default"===M.keyboard.options.layoutName?"shift":"default";M.keyboard.setOptions({layoutName:e})},uid:function(){return"mdp-"+Date.now().toString(36)+Math.random().toString(36).substr(2)},makeKeyboardDraggable:function(){let e,t,n,a,o=M.keyboardBox,i=document.documentElement,r=!1,d=0,l=0;function s(e){"touchstart"===e.type?(n=e.touches[0].clientX-d,a=e.touches[0].clientY-l):(n=e.clientX-d,a=e.clientY-l),e.target===o&&(r=!0)}function c(){n=e,a=t,r=!1}function p(i){var s,c;r&&("touchmove"===i.type?(e=i.touches[0].clientX-n,t=i.touches[0].clientY-a):(e=i.clientX-n,t=i.clientY-a),d=e,l=t,s=e,c=t,o.style.transform="translate3d("+s+"px, "+c+"px, 0)")}i.addEventListener("touchstart",s,!1),i.addEventListener("touchend",c,!1),i.addEventListener("touchmove",p,!1),i.addEventListener("mousedown",s,!1),i.addEventListener("mouseup",c,!1),i.addEventListener("mousemove",p,!1)}},O={readingGuideStyle:document.createElement("style"),readingGuideEl:null,init:function(){document.querySelector("#mdp-readabler-action-reading-guide").addEventListener("ReadablerToggleBoxChanged",O.readingGuide)},readingGuide:function(e){e.target.classList.contains("mdp-active")?O.createReadingGuide():O.removeReadingGuide()},createReadingGuide:function(){document.querySelectorAll(".mdp-readabler-reading-guide-element").length||(O.addCSS(),O.readingGuideEl=document.createElement("div"),O.readingGuideEl.classList.add("mdp-readabler-reading-guide-element"),document.body.appendChild(O.readingGuideEl),document.addEventListener("mousemove",O.moveReadingGuide),document.addEventListener("click",O.moveReadingGuide))},moveReadingGuide:function(e){let t=e.clientX-Math.round(O.readingGuideEl.clientWidth/2),n=e.clientY;O.readingGuideEl.style.transform="translate3d("+t+"px,"+n+"px,0px)"},removeReadingGuide:function(){document.body.classList.remove("mdp-readabler-reading-guide"),O.readingGuideEl.remove(),document.removeEventListener("mousemove",O.moveReadingGuide),document.removeEventListener("click",O.moveReadingGuide)},addCSS:function(){document.body.classList.add("mdp-readabler-reading-guide"),O.readingGuideStyle.innerHTML=`\n                /*noinspection CssUnusedSymbol*/\n                .mdp-readabler-reading-guide-element {\n                    display: none;\n                }\n\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-reading-guide .mdp-readabler-reading-guide-element {\n                    display: block;\n                    position: fixed;\n                    top: 0;\n                    left: auto;\n                    right: auto;\n                    margin: auto;\n                    width: ${e.readingGuideWidth}px;\n                    max-width: 90%;\n                    height: ${e.readingGuideHeight}px;\n                    border-radius: ${e.readingGuideBorderRadius}px;\n                    pointer-events: none;\n                    background-color: ${e.readingGuideBackgroundColor};\n                    border: solid ${e.readingGuideBorderWidth}px ${e.readingGuideBorderColor};\n                    z-index: 999999;\n                }\n            `,document.head.appendChild(O.readingGuideStyle)}},A={select:document.getElementById("mdp-readabler-useful-links"),init:function(){A.buildSelect(),A.select.addEventListener("change",e=>{window.location.href=e.target.value})},grabLinks:function(){let t=document.querySelectorAll("a"),n=[];n.push([e.HOME,window.location.origin]);for(let e=0;e<t.length;e++){let a=t[e].innerText;if(a=a.replace(/\s+/g," ").trim(),""===a)continue;a=a.substring(0,42);let o=t[e].href;o=o.trim(),""!==o&&("#"!==o&&(o.toLowerCase().startsWith("javascript:")||n.some((function(e){return e[1]===o}))||n.push([a,o])))}return n},buildSelect:function(){let e=A.grabLinks();for(let t=0;t<e.length;t++){let n=document.createElement("option");n.textContent=e[t][0],n.value=e[t][1],A.select.appendChild(n)}}},D={stopAnimationsStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-stop-animations").addEventListener("ReadablerToggleBoxChanged",D.stopAnimations)},stopAnimations:function(e){if(!e.target.classList.contains("mdp-active"))return document.body.classList.remove("mdp-readabler-stop-animations"),void document.querySelectorAll("video").forEach(e=>e.play());document.body.classList.add("mdp-readabler-stop-animations"),D.stopAnimationsStyle.innerHTML="\n\n                /*noinspection CssUnusedSymbol,CssUnknownProperty*/\n                body.mdp-readabler-stop-animations *{\n                    -webkit-transition: none !important;\n                    -moz-transition: none !important;\n                    -ms-transition: none !important;\n                    -o-transition: none !important;\n                    transition: none !important;\n                    -webkit-animation-fill-mode: forwards !important;\n                    -moz-animation-fill-mode: forwards !important;\n                    -ms-animation-fill-mode: forwards !important;\n                    -o-animation-fill-mode: forwards !important;\n                    animation-fill-mode: forwards !important;\n                    -webkit-animation-iteration-count: 1 !important;\n                    -moz-animation-iteration-count: 1 !important;\n                    -ms-animation-iteration-count: 1 !important;\n                    -o-animation-iteration-count: 1 !important;\n                    animation-iteration-count: 1 !important;\n                    -webkit-animation-duration: .01s !important;\n                    -moz-animation-duration: .01s !important;\n                    -ms-animation-duration: .01s !important;\n                    -o-animation-duration: .01s !important;\n                    animation-duration: .01s !important;\n                }\n\n            ",document.head.appendChild(D.stopAnimationsStyle),document.querySelectorAll("video").forEach(e=>e.pause())}},U={readingMaskStyle:document.createElement("style"),readingMaskTop:null,readingMaskBottom:null,init:function(){document.querySelector("#mdp-readabler-action-reading-mask").addEventListener("ReadablerToggleBoxChanged",U.readingMask)},readingMask:function(e){e.target.classList.contains("mdp-active")?U.createReadingMask():U.removeReadingMask()},createReadingMask:function(){document.querySelectorAll(".mdp-readabler-reading-mask-top").length||(document.body.classList.add("mdp-readabler-reading-mask"),U.readingMaskTop=document.createElement("div"),U.readingMaskTop.classList.add("mdp-readabler-reading-mask-top"),document.body.appendChild(U.readingMaskTop),U.readingMaskBottom=document.createElement("div"),U.readingMaskBottom.classList.add("mdp-readabler-reading-mask-bottom"),document.body.appendChild(U.readingMaskBottom),document.addEventListener("mousemove",U.moveReadingMask))},moveReadingMask:function(t){let n=t.clientY,a=Math.round(e.readingMaskHeight/2);U.readingMaskTop.style.height=n-a+"px",U.readingMaskBottom.style.top=n+a+"px"},removeReadingMask:function(){document.body.classList.remove("mdp-readabler-reading-mask"),U.readingMaskTop.remove(),U.readingMaskBottom.remove(),document.removeEventListener("mousemove",U.moveReadingMask)}},H={highlightHoverStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-highlight-hover").addEventListener("ReadablerToggleBoxChanged",H.highlightHover)},highlightHover:function(t){t.target.classList.contains("mdp-active")?(document.body.classList.add("mdp-readabler-highlight-hover"),H.highlightHoverStyle.innerHTML=`\n\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-highlight-hover *:hover {\n                    outline-style: ${e.highlightHoverStyle} !important;\n                    outline-color: ${e.highlightHoverColor} !important;\n                    outline-width: ${e.highlightHoverWidth}px !important;\n                    outline-offset: ${e.highlightHoverOffset}px !important;\n                }\n                \n            `,document.head.appendChild(H.highlightHoverStyle)):document.body.classList.remove("mdp-readabler-highlight-hover")}},P={highlightFocusStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-highlight-focus").addEventListener("ReadablerToggleBoxChanged",P.highlightFocus)},highlightFocus:function(t){t.target.classList.contains("mdp-active")?(document.body.classList.add("mdp-readabler-highlight-focus"),P.highlightFocusStyle.innerHTML=`\n\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-highlight-focus *:focus {\n                    outline-style: ${e.highlightFocusStyle} !important;\n                    outline-color: ${e.highlightFocusColor} !important;\n                    outline-width: ${e.highlightFocusWidth}px !important;\n                    outline-offset: ${e.highlightFocusOffset}px !important;\n                }\n                \n            `,document.head.appendChild(P.highlightFocusStyle)):document.body.classList.remove("mdp-readabler-highlight-focus")}},$={bigBlackCursorStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-big-black-cursor").addEventListener("ReadablerToggleBoxChanged",$.bigBlackCursor)},bigBlackCursor:function(t){t.target.classList.contains("mdp-active")?($.disableWhite(),document.body.classList.add("mdp-readabler-big-black-cursor"),$.bigBlackCursorStyle.innerHTML=`\n\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-big-black-cursor,\n                body.mdp-readabler-big-black-cursor * {\n                    /*noinspection CssUnknownTarget*/\n                    cursor: url("${e.pluginURL}images/cursor/black-cursor.svg"), default !important\n                }\n                \n                body.mdp-readabler-big-black-cursor * input, \n                body.mdp-readabler-big-black-cursor * textarea, \n                body.mdp-readabler-big-black-cursor * select, \n                body.mdp-readabler-big-black-cursor * a, \n                body.mdp-readabler-big-black-cursor * button, \n                body.mdp-readabler-big-black-cursor * [role=button] {\n                    /*noinspection CssUnknownTarget*/\n                    cursor: url("${e.pluginURL}images/cursor/black-pointer.svg"), default !important;\n                }\n                \n            `,document.head.appendChild($.bigBlackCursorStyle)):document.body.classList.remove("mdp-readabler-big-black-cursor")},disableWhite:function(){let e=document.getElementById("mdp-readabler-action-big-white-cursor");null!==e&&e.classList.contains("mdp-active")&&e.click()}},F={bigWhiteCursorStyle:document.createElement("style"),init:function(){document.querySelector("#mdp-readabler-action-big-white-cursor").addEventListener("ReadablerToggleBoxChanged",F.bigWhiteCursor)},bigWhiteCursor:function(t){t.target.classList.contains("mdp-active")?(F.disableBlack(),document.body.classList.add("mdp-readabler-big-white-cursor"),F.bigWhiteCursorStyle.innerHTML=`\n\n                /*noinspection CssUnusedSymbol*/\n                body.mdp-readabler-big-white-cursor,\n                body.mdp-readabler-big-white-cursor * {\n                    /*noinspection CssUnknownTarget*/\n                    cursor: url("${e.pluginURL}images/cursor/white-cursor.svg"), default !important\n                }\n                \n                body.mdp-readabler-big-white-cursor * input, \n                body.mdp-readabler-big-white-cursor * textarea, \n                body.mdp-readabler-big-white-cursor * select, \n                body.mdp-readabler-big-white-cursor * a, \n                body.mdp-readabler-big-white-cursor * button, \n                body.mdp-readabler-big-white-cursor * [role=button] {\n                    /*noinspection CssUnknownTarget*/\n                    cursor: url("${e.pluginURL}images/cursor/white-pointer.svg"), default !important;\n                }\n                \n            `,document.head.appendChild(F.bigWhiteCursorStyle)):document.body.classList.remove("mdp-readabler-big-white-cursor")},disableBlack:function(){let e=document.getElementById("mdp-readabler-action-big-black-cursor");null!==e&&e.classList.contains("mdp-active")&&e.click()}},N={readabler:null,AudioContext:window.AudioContext||window.webkitAudioContext||!1,mdp_readabler_context:null,init:function(){if(document.querySelectorAll("#mdp-readabler-action-text-to-speech").length<1)return;document.querySelector("#mdp-readabler-action-text-to-speech").addEventListener("ReadablerToggleBoxChanged",N.textToSpeech)},webAudioTouchUnlock:function(){null===N.mdp_readabler_context&&(N.mdp_readabler_context=new AudioContext,N.mdp_readabler_context.resume())},textToSpeech:function(e){e.target.classList.contains("mdp-active")?(N.readabler=new Q,N.readabler.init(),document.body.addEventListener("click",N.webAudioTouchUnlock,!1)):(N.readabler=null,document.body.removeEventListener("click",N.webAudioTouchUnlock,!1))}},_={init:function(){document.querySelector("#mdp-readabler-action-keyboard-navigation").addEventListener("ReadablerToggleBoxChanged",_.keyboardNavigation)},keyboardNavigation:function(e){if(!e.target.classList.contains("mdp-active"))return document.body.classList.remove("mdp-readabler-keyboard-navigation"),_.restoreOriginalTabIndex(),void(Z.enabled=!1);document.body.classList.add("mdp-readabler-keyboard-navigation"),_.makeFocusable(),Z.enabled=!0},makeFocusable:function(){document.querySelectorAll('nav, [role="navigation"], h1, h2, h3, h4, h5, h6, [role="heading"], form:not([disabled]), button:not([disabled]), [role="button"]:not([disabled]), img, picture, svg').forEach(e=>{e.tabIndex<0&&(e.dataset.readablerOriginalTabIndex=e.tabIndex,e.tabIndex=0)})},restoreOriginalTabIndex:function(){document.querySelectorAll('nav, [role="navigation"], h1, h2, h3, h4, h5, h6, [role="heading"], form:not([disabled]), button:not([disabled]), [role="button"]:not([disabled]), img, picture, svg').forEach(e=>{null!=e.dataset.readablerOriginalTabIndex&&(e.tabIndex=e.dataset.readablerOriginalTabIndex,delete e.dataset.readablerOriginalTabIndex)})},setFocus:function(e,t=!0){if(document.activeElement){let n=Array.prototype.filter.call(document.querySelectorAll(e),(function(e){return e.offsetWidth>0||e.offsetHeight>0||e===document.activeElement})),a=n.indexOf(document.activeElement);if(a>-1){let e;e=t?n[a+1]||n[0]:n[a-1]||n[n.length-1],e.focus()}else t?n[0].focus():n[n.length-1].focus()}}},G={init:function(){if(null===document.getElementById("mdp-readabler-statement-btn"))return;document.getElementById("mdp-readabler-statement-btn").addEventListener("click",G.show),document.getElementById("mdp-readabler-close-statement-btn").addEventListener("click",G.close)},show:function(e){e.preventDefault(),document.getElementById("mdp-readabler-accessibility-statement-box").classList.add("mdp-open")},close:function(e){e.preventDefault(),document.getElementById("mdp-readabler-accessibility-statement-box").classList.remove("mdp-open")}},W={init:function(){let e=document.getElementById("mdp-readabler-reset-btn");e&&e.addEventListener("click",W.reset)},reset:function(e){e.preventDefault();let t=Object.keys(localStorage);for(const e in t)t[e].toString().startsWith("mdpReadabler")&&localStorage.removeItem(t[e]);location.reload()}},z={init:function(){let e=document.getElementById("mdp-readabler-hide-btn");e&&e.addEventListener("click",z.hide)},hide:function(t){t.preventDefault(),window.confirm(e.HIDE_ACCESSIBILITY_INTERFACE)&&(z.writeCookie("mdp-readabler-hide","1",365),window.location.reload())},writeCookie:function(e,t,n){let a=new Date;return n=n||365,a.setTime(+a+864e5*n),window.document.cookie=e+"="+t+"; expires="+a.toGMTString()+"; path=/",t}};function K(L){e=L,document.addEventListener("DOMContentLoaded",()=>{t.init(),n.init(),i.init(),r.init(),d.init(),G.init(),W.init(),z.init(),e.onlineDictionary&&a.init(),o.init(),e.contentScaling&&l.init(),e.fontSizing&&s.init(),e.lineHeight&&c.init(),e.letterSpacing&&p.init(),(e.readableFont||e.profileVisuallyImpaired||e.profileBlindUsers)&&u.init(),e.dyslexiaFont&&m.init(),(e.highlightTitles||e.profileCognitiveDisability)&&b.init(),(e.highlightLinks||e.profileCognitiveDisability)&&g.init(),e.textMagnifier&&h.init(),e.alignCenter&&y.init(),e.alignLeft&&f.init(),e.alignRight&&v.init(),e.darkContrast&&x.init(),e.lightContrast&&k.init(),e.monochrome&&S.init(),(e.highSaturation||e.profileVisuallyImpaired||e.profileAdhdFriendly)&&E.init(),e.highContrast&&w.init(),(e.lowSaturation||e.profileEpilepsy)&&C.init(),e.textColors&&T.init(),e.titleColors&&R.init(),e.backgroundColors&&q.init(),e.muteSounds&&B.init(),e.hideImages&&I.init(),(e.virtualKeyboard||e.profileBlindUsers)&&M.init(),e.readingGuide&&O.init(),e.usefulLinks&&A.init(),(e.stopAnimations||e.profileEpilepsy||e.profileCognitiveDisability||e.profileAdhdFriendly)&&D.init(),(e.readingMask||e.profileAdhdFriendly)&&U.init(),e.highlightHover&&H.init(),e.highlightFocus&&P.init(),e.bigBlackCursor&&$.init(),e.bigWhiteCursor&&F.init(),(e.textToSpeech||e.profileBlindUsers)&&N.init(),(e.keyboardNavigation||e.profileBlindUsers)&&_.init(),r.loadSaved(),i.loadSaved(),d.loadSaved(),o.loadSaved()})}function X(e,t=" "){return e.toLowerCase().split(t).map(e=>e.charAt(0).toUpperCase()+e.slice(1)).join(t)}function Y(e){return localStorage.getItem("mdpReadabler"+e)}function V(e,t){localStorage.setItem("mdpReadabler"+e,t)}function j(e,t){let n=0;return function(...a){clearTimeout(n),n=setTimeout(e.bind(this,...a),t||0)}}const Q=function(){let t=null,n=!1;function a(e,t){const n=document.createElement("div");return n.classList.add("mdp-readabler-tts-button"),n.innerHTML=e,n.onclick=t,"mdp-readabler-tts-preloader"===n.id?n.style.transition="none":(n.onmouseover=function(){this.style.transform="scale(1.2)"},n.onmouseout=function(){this.style.transform="scale(1)"}),n}function o(){t&&(t.onended=null,t.stop(0))}return function(){const i={gspeak:!0,disable:!1},r='<svg class="selection__icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" enable-background="new 0 0 24 24" width="24" height="24"><path d="M19.3,10.7L9.1,4.2C8.8,4,8.4,4,8.1,4C7,4,7,4.9,7,5.1v13.4c0,0.2,0,1.1,1.1,1.1c0.3,0,0.7,0,1-0.2l10.2-6.5c0.8-0.5,0.7-1.1,0.7-1.1S20.1,11.2,19.3,10.7z"/></svg>',d='<svg class="selection__icon" id="mdp-readabler-tts-preloader" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24"><rect x="3" y="7" rx="2" ry="2" width="4" height="10"><animate attributeName="y" calcMode="spline" values="7;9;7" keyTimes="0;0.5;1" dur=".6" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/><animate attributeName="height" calcMode="spline" values="10;6;10" keyTimes="0;0.5;1" dur=".6" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/></rect><rect x="8" y="2" rx="2" ry="2" width="4" height="20"><animate attributeName="y" calcMode="spline" values="2;4;2" keyTimes="0;0.5;1" dur=".5" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/><animate attributeName="height" calcMode="spline" values="20;16;20" keyTimes="0;0.5;1" dur=".5" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/></rect><rect x="13" y="4" rx="2" ry="2" width="4" height="16"><animate attributeName="y" calcMode="spline" values="4;7;4" keyTimes="0;0.5;1" dur=".7" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/><animate attributeName="height" calcMode="spline" values="16;10;16" keyTimes="0;0.5;1" dur=".7" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/></rect><rect x="18" y="8" rx="2" ry="2" width="4" height="8"><animate attributeName="y" calcMode="spline" values="8;10;8" keyTimes="0;0.5;1" dur=".8" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/><animate attributeName="height" calcMode="spline" values="8;4;8" keyTimes="0;0.5;1" dur=".8" keySplines="0 0.5 0.5 1;0 0.5 0.5 1" begin="0" repeatCount="indefinite"/></rect></svg>',l='<svg class="selection__icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24"><path d="M18.001 4.2H6A1.8 1.8 0 0 0 4.2 5.999V18A1.8 1.8 0 0 0 5.999 19.8H18a1.8 1.8 0 0 0 1.799-1.799V6c0-.992-.807-1.799-1.799-1.799z"/></svg>';let s="",c="",p="",u={},m=0,b=0;function g(){return new a(r,(function(){if(document.querySelector(".mdp-readabler-tts.stop"))return o(),void h();!function(){const e=document.querySelector(".mdp-readabler-tts .selection__icon"),t=document.createElement("div");t.innerHTML=d,e.parentNode.replaceChild(t,e);const n=document.querySelector(".mdp-readabler-tts");n.classList.remove("stop"),n.classList.add("loading")}();let n=new XMLHttpRequest;n.open("POST",e.textToSpeechAjaxUrl,!0),n.setRequestHeader("Content-Type","application/x-www-form-urlencoded"),n.onload=function(){if(this.status>=200&&this.status<400){if(!N.AudioContext)return void console.warn("Error with creating AudioContext.");N.mdp_readabler_context.decodeAudioData(this.response,(function(e){const n=N.mdp_readabler_context.createBufferSource();n.buffer=e,o(),t=n,n.connect(N.mdp_readabler_context.destination),n.onended=h,n.start(0),function(){const e=document.querySelector(".mdp-readabler-tts .selection__icon"),t=document.createElement("div");t.innerHTML=l,e.parentNode.replaceChild(t,e);const n=document.querySelector(".mdp-readabler-tts");n.classList.remove("loading"),n.classList.add("stop")}()}),(function(e){console.warn("Error with decoding audio data"+e.err)}))}else console.error(this.response)},n.onerror=function(){console.error("Connection error.")},n.responseType="arraybuffer",n.send("action=readablergspeak&nonce="+e.textToSpeechNonce+"&text="+encodeURIComponent(p))}))}function h(){document.querySelector(".mdp-readabler-tts.stop")&&document.querySelector(".mdp-readabler-tts").remove()}function y(){const e=s.getRangeAt(0).getBoundingClientRect(),t=window.pageXOffset||document.documentElement.scrollTop||document.body.scrollTop;b=e.left+(e.width-52*u.length)/2,m=n?e.bottom+t+52+10:e.top+t-52-10}function f(){if(document.querySelector(".mdp-readabler-tts")){y();let e=document.querySelector(".mdp-readabler-tts");e.style.top=m+"px",e.style.left=b+"px"}}function v(){u=function(){const e=[{feature:"gspeak",call:g()}],t=document.createElement("div");let n=0;return e.forEach((function(e){i[e.feature]&&(t.appendChild(e.call),n++)})),{icons:t,length:n}}(),y();let e="";n&&(e="transform-origin: top; transform: scale(1,-1)");const t=document.createElement("div");t.className="mdp-readabler-tts",t.style="top:"+m+"px;left:"+b+"px;"+e,t.appendChild(u.icons);const a=document.createElement("div");a.classList.add("mdp-readabler-tts-arrow"),a.style="left:"+(52*u.length/2-8)+"px;",i.disable||t.appendChild(a),document.body.appendChild(t)}function L(){function e(){return null!==N.readabler&&!!window.getSelection().toString()}function t(){let e;if(document.selection&&document.selection.createRange)return e=document.selection.createRange(),e.htmlText;if(window.getSelection){const t=window.getSelection();if(t.rangeCount>0){e=t.getRangeAt(0);const n=e.cloneContents(),a=document.createElement("div");return a.appendChild(n),a.innerHTML}return""}return""}function a(){let e;if(n)return window.getSelection?e=window.getSelection():document.getSelection?e=document.getSelection():document.selection&&(e=document.selection.createRange().text),e;if(window.getSelection&&(e=window.getSelection()).modify){if(e=window.getSelection(),!e.isCollapsed){const t=document.createRange();t.setStart(e.anchorNode,e.anchorOffset),t.setEnd(e.focusNode,e.focusOffset);const n=t.collapsed;t.detach();const a=e.focusNode,o=e.focusOffset;let i;e.collapse(e.anchorNode,e.anchorOffset),i=n?["backward","forward"]:["forward","backward"],e.modify("move",i[0],"character"),e.modify("move",i[1],"word"),e.extend(a,o),e.modify("extend",i[1],"character"),e.modify("extend",i[0],"word")}}else if((e=document.selection)&&"Control"!==e.type){const t=e.createRange();if(t.text){for(t.expand("word");/\s$/.test(t.text);)t.moveEnd("character",-1);t.select()}}return e}const o=function(){setTimeout((function(){document.querySelector(".mdp-readabler-tts")?e()?(s=a(),c=t(),p=c,f(),(document.querySelector(".mdp-readabler-tts.stop")||document.querySelector(".mdp-readabler-tts.loading"))&&function(){const e=document.querySelector(".mdp-readabler-tts .selection__icon"),t=document.createElement("div");t.innerHTML=r,e.parentNode.replaceChild(t,e);const n=document.querySelector(".mdp-readabler-tts");n.classList.remove("stop"),n.classList.remove("loading")}()):document.querySelector(".mdp-readabler-tts.stop")||document.querySelector(".mdp-readabler-tts.loading")||document.querySelector(".mdp-readabler-tts").remove():e()&&(s=a(),c=t(),p=c,v())}),10)};window.addEventListener("mouseup",o,!0),window.addEventListener("touchend",o,!1),window.addEventListener("touchcancel",o,!1),window.addEventListener("selectionchange",o,!1),window.addEventListener("resize",f,!1),window.addEventListener("touchstart",(function e(){n=!0,document.addEventListener("selectionchange",o,!0),window.removeEventListener("touchstart",e,!1)}))}return{config:function(e){return i.gspeak=void 0===e.gspeak?i.gspeak:e.gspeak,i.disable=void 0===e.disable?i.disable:e.disable,this},init:function(){return L(),this}}}}();let Z=function(){const t={enabled:!1,trigger:n};function n(t,n){u?v():function(){const t=function(){const t=i.createElement("div");return t.innerHTML='<svg id="focus-snail_svg" width="1000" height="800">\t\t<linearGradient id="focus-snail_gradient">\t\t\t<stop id="focus-snail_start" offset="0%" stop-color="'+e.highlightFocusColor+'" stop-opacity="0"/>\t\t\t<stop id="focus-snail_middle" offset="80%" stop-color="'+e.highlightFocusColor+'" stop-opacity="0.8"/>\t\t\t<stop id="focus-snail_end" offset="100%" stop-color="'+e.highlightFocusColor+'" stop-opacity="0"/>\t\t</linearGradient>\t\t<polygon id="focus-snail_polygon" fill="url(#focus-snail_gradient)"/>\t</svg>',t}();u=f(t,"svg"),m=f(t,"polygon"),b=f(t,"start"),g=f(t,"middle"),h=f(t,"end"),y=f(t,"gradient"),d.appendChild(u)}();const r=S(t),l=S(n);let c=0,L=0,w=0,C=0;const T=function(e){return 50*Math.pow(function(e,t,n){if(e<=t)return t;if(e>=n)return n;return e}(e,32,1024),1/3)}(function(e,t,n,a){const o=e-n,i=t-a;return Math.sqrt(o*o+i*i)}(r.left,r.top,l.left,l.top));let R=!0;!function(e,t){const n=Date.now();!function a(){s=requestAnimationFrame((function(){const o=Date.now()-n;e(o/t),o<t&&a()}))}()}((function(e){if(R){!function(){const e=E();u.style.left=e.left+"px",u.style.top=e.top+"px",u.setAttribute("width",o.innerWidth.toString()),u.setAttribute("height",o.innerHeight.toString()),u.classList.add("focus-snail_visible"),c=l.left-e.left,L=r.left-e.left,w=l.top-e.top,C=r.top-e.top}(),function(e,t,n,a,o,i,r,d,l){const s=p(t,n,a,o),c=p(i,r,d,l),u=function(e){const t=Math.floor(e/Math.PI*2)+2,n=Math.PI/4+Math.PI/2*t,a=Math.sqrt(2),o=Math.cos(Math.abs(n-e))*a,i=o*Math.cos(e),r=o*Math.sin(e);return{x1:i<0?1:0,y1:r<0?1:0,x2:i>=0?i:i+1,y2:r>=0?r:r+1}}(Math.atan2(s.y-c.y,s.x-c.x));e.setAttribute("x1",u.x1),e.setAttribute("y1",u.y1),e.setAttribute("x2",isNaN(u.x2)?0:u.x2),e.setAttribute("y2",isNaN(u.y2)?0:u.y2)}(y,L,C,r.width,r.height,c,w,l.width,l.height);!function(e,t){t.points.clear();for(let n=0;n<e.length;n++){const a=e[n];x(t,a)}}(function(e,t){let n=0;e.top<t.top&&(n=1);e.right>t.right&&(n+=2);e.bottom>t.bottom&&(n+=4);e.left<t.left&&(n+=8);const a=k(e).concat(k(t)),o=[],i=[[],[0,1],[1,2],[0,1,2],[2,3],[0,1],[1,2,3],[0,1,2,3],[3,0],[3,0,1],[3,0],[3,0,1,2],[2,3,0],[2,3,0,1],[1,2,3,0],[0,1,2,3,0]][n];let r;for(r=0;r<i.length;r++)o.push(a[i[r]]);for(;r--;)o.push(a[i[r]+4]);return o}({top:C,right:L+r.width,bottom:C+r.height,left:L},{top:w,right:c+l.width,bottom:w+l.height,left:c}),m)}const t=e>.4?a((e-.4)/.6):0,n=e<.8?a(e/.8):1;b.setAttribute("offset",100*t+"%"),g.setAttribute("offset",100*n+"%"),e>=1&&v(),R=!1}),T)}function a(e){return 2*e-e*e}let o=window;const i=document,r=i.documentElement,d=i.body;let l=null,s=0,c=0;function p(e,t,n,a){return{x:e+n/2,y:t+a/2}}r.addEventListener("keydown",(function(e){t.enabled&&(c=Date.now())}),!1),r.addEventListener("blur",(function(e){t.enabled&&(v(),l=L()?e.target:null)}),!0),r.addEventListener("focus",(function(e){l&&L()&&n(l,e.target)}),!0);let u=null,m=null,b=null,g=null,h=null,y=null;function f(e,t){return e.querySelector("#focus-snail_"+t)}function v(){s&&(cancelAnimationFrame(s),s=0,u.classList.remove("focus-snail_visible"))}function L(){return Date.now()-c<42}function x(e,t){const n=e.ownerSVGElement.createSVGPoint();n.x=isNaN(t.x)?0:t.x,n.y=isNaN(t.y)?0:t.y,e.points.appendItem(n)}function k(e){return[{x:e.left,y:e.top},{x:e.right,y:e.top},{x:e.right,y:e.bottom},{x:e.left,y:e.bottom}]}function S(e){const t=function(e){const t=e.getBoundingClientRect(),n=E(),a=r.clientTop||d.clientTop,o=r.clientLeft||d.clientLeft,i=t.top+n.top-a,l=t.left+n.left-o;return{top:i||0,left:l||0}}(e);return{left:t.left-0,top:t.top-0,width:Math.max(12,e.offsetWidth)+0,height:Math.max(8,e.offsetHeight)+0}}function E(){return{top:o.pageYOffset||r.scrollTop||0,left:o.pageXOffset||r.scrollLeft||0}}const w=i.createElement("style");return w.textContent="#focus-snail_svg {\tposition: absolute;\ttop: 0;\tright: 0;\tbottom: 0;\tleft: 0;\tmargin: 0;\tbackground: transparent;\tvisibility: hidden;\tpointer-events: none;\t-webkit-transform: translateZ(0);}#focus-snail_svg.focus-snail_visible {\tvisibility: visible;\tz-index: 999;}#focus-snail_polygon {\tstroke-width: 0;}",d.appendChild(w),t}();return{run:function(e){K(e)}}}();window.addEventListener("DOMContentLoaded",e=>{null!==document.querySelector("#mdp-readabler-demo")&&document.querySelector("#mdp-readabler-demo").addEventListener("click",(function(){MicroModal.show("mdp-readabler-popup-box",{openClass:"mdp-is-open",disableFocus:!1})}))}),mdpReadabler.run(window.mdpReadablerOptions);